/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Preview: ImageVector
    get() {
        if (_preview != null) {
            return _preview!!
        }
        _preview = materialIcon(name = "Sharp.Preview") {
            materialPath {
                moveTo(3.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(3.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(13.5f, 13.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveToRelative(-1.5f, -0.67f, -1.5f, -1.5f)
                curveToRelative(0.0f, -0.83f, 0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveTo(13.5f, 12.17f, 13.5f, 13.0f)
                close()
                moveTo(12.0f, 9.0f)
                curveToRelative(-2.73f, 0.0f, -5.06f, 1.66f, -6.0f, 4.0f)
                curveToRelative(0.94f, 2.34f, 3.27f, 4.0f, 6.0f, 4.0f)
                reflectiveCurveToRelative(5.06f, -1.66f, 6.0f, -4.0f)
                curveTo(17.06f, 10.66f, 14.73f, 9.0f, 12.0f, 9.0f)
                close()
                moveTo(12.0f, 15.5f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.12f, 2.5f, 2.5f)
                curveTo(14.5f, 14.38f, 13.38f, 15.5f, 12.0f, 15.5f)
                close()
            }
        }
        return _preview!!
    }

private var _preview: ImageVector? = null
