/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RuleFolder: ImageVector
    get() {
        if (_ruleFolder != null) {
            return _ruleFolder!!
        }
        _ruleFolder = materialIcon(name = "Sharp.RuleFolder") {
            materialPath {
                moveTo(22.0f, 6.0f)
                horizontalLineTo(12.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(7.83f, 16.0f)
                lineTo(5.0f, 13.17f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(3.54f, -3.54f)
                lineToRelative(1.41f, 1.41f)
                lineTo(7.83f, 16.0f)
                close()
                moveTo(17.41f, 13.0f)
                lineTo(19.0f, 14.59f)
                lineTo(17.59f, 16.0f)
                lineTo(16.0f, 14.41f)
                lineTo(14.41f, 16.0f)
                lineTo(13.0f, 14.59f)
                lineTo(14.59f, 13.0f)
                lineTo(13.0f, 11.41f)
                lineTo(14.41f, 10.0f)
                lineTo(16.0f, 11.59f)
                lineTo(17.59f, 10.0f)
                lineTo(19.0f, 11.41f)
                lineTo(17.41f, 13.0f)
                close()
            }
        }
        return _ruleFolder!!
    }

private var _ruleFolder: ImageVector? = null
