/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Stars: ImageVector
    get() {
        if (_stars != null) {
            return _stars!!
        }
        _stars = materialIcon(name = "Sharp.Stars") {
            materialPath {
                moveTo(11.99f, 2.0f)
                curveTo(6.47f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.47f, 10.0f, 9.99f, 10.0f)
                curveTo(17.52f, 22.0f, 22.0f, 17.52f, 22.0f, 12.0f)
                reflectiveCurveTo(17.52f, 2.0f, 11.99f, 2.0f)
                close()
                moveTo(16.23f, 18.0f)
                lineTo(12.0f, 15.45f)
                lineTo(7.77f, 18.0f)
                lineToRelative(1.12f, -4.81f)
                lineToRelative(-3.73f, -3.23f)
                lineToRelative(4.92f, -0.42f)
                lineTo(12.0f, 5.0f)
                lineToRelative(1.92f, 4.53f)
                lineToRelative(4.92f, 0.42f)
                lineToRelative(-3.73f, 3.23f)
                lineTo(16.23f, 18.0f)
                close()
            }
        }
        return _stars!!
    }

private var _stars: ImageVector? = null
