/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ModelTraining: ImageVector
    get() {
        if (_modelTraining != null) {
            return _modelTraining!!
        }
        _modelTraining = materialIcon(name = "TwoTone.ModelTraining") {
            materialPath {
                moveTo(15.5f, 13.5f)
                curveToRelative(0.0f, 2.0f, -2.5f, 3.5f, -2.5f, 5.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.5f, -2.5f, -3.0f, -2.5f, -5.0f)
                curveToRelative(0.0f, -1.93f, 1.57f, -3.5f, 3.5f, -3.5f)
                horizontalLineToRelative(0.0f)
                curveTo(13.93f, 10.0f, 15.5f, 11.57f, 15.5f, 13.5f)
                close()
                moveTo(13.0f, 19.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(19.5f)
                close()
                moveTo(19.0f, 13.0f)
                curveToRelative(0.0f, 1.68f, -0.59f, 3.21f, -1.58f, 4.42f)
                lineToRelative(1.42f, 1.42f)
                curveTo(20.18f, 17.27f, 21.0f, 15.23f, 21.0f, 13.0f)
                curveToRelative(0.0f, -2.74f, -1.23f, -5.19f, -3.16f, -6.84f)
                lineToRelative(-1.42f, 1.42f)
                curveTo(17.99f, 8.86f, 19.0f, 10.82f, 19.0f, 13.0f)
                close()
                moveTo(16.0f, 5.0f)
                lineToRelative(-4.0f, -4.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveToRelative(-4.97f, 0.0f, -9.0f, 4.03f, -9.0f, 9.0f)
                curveToRelative(0.0f, 2.23f, 0.82f, 4.27f, 2.16f, 5.84f)
                lineToRelative(1.42f, -1.42f)
                curveTo(5.59f, 16.21f, 5.0f, 14.68f, 5.0f, 13.0f)
                curveToRelative(0.0f, -3.86f, 3.14f, -7.0f, 7.0f, -7.0f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                verticalLineToRelative(3.0f)
                lineTo(16.0f, 5.0f)
                close()
            }
        }
        return _modelTraining!!
    }

private var _modelTraining: ImageVector? = null
