/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PrecisionManufacturing: ImageVector
    get() {
        if (_precisionManufacturing != null) {
            return _precisionManufacturing!!
        }
        _precisionManufacturing = materialIcon(name = "TwoTone.PrecisionManufacturing") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.71f, 10.0f)
                lineToRelative(2.46f, 8.0f)
                lineToRelative(1.94f, 0.0f)
                lineToRelative(-4.3f, -8.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 7.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(19.93f, 8.35f)
                lineToRelative(-3.6f, 1.68f)
                lineTo(14.0f, 7.7f)
                verticalLineTo(6.3f)
                lineToRelative(2.33f, -2.33f)
                lineToRelative(3.6f, 1.68f)
                curveToRelative(0.38f, 0.18f, 0.82f, 0.01f, 1.0f, -0.36f)
                curveToRelative(0.18f, -0.38f, 0.01f, -0.82f, -0.36f, -1.0f)
                lineToRelative(-3.92f, -1.83f)
                curveToRelative(-0.38f, -0.18f, -0.83f, -0.1f, -1.13f, 0.2f)
                lineTo(13.78f, 4.4f)
                curveTo(13.6f, 4.16f, 13.32f, 4.0f, 13.0f, 4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(8.82f)
                curveTo(8.4f, 4.84f, 7.3f, 4.0f, 6.0f, 4.0f)
                curveTo(4.34f, 4.0f, 3.0f, 5.34f, 3.0f, 7.0f)
                curveToRelative(0.0f, 1.1f, 0.6f, 2.05f, 1.48f, 2.58f)
                lineTo(7.08f, 18.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(13.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-1.62f)
                lineTo(8.41f, 8.77f)
                curveTo(8.58f, 8.53f, 8.72f, 8.28f, 8.82f, 8.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.32f, 0.0f, 0.6f, -0.16f, 0.78f, -0.4f)
                lineToRelative(1.74f, 1.74f)
                curveToRelative(0.3f, 0.3f, 0.75f, 0.38f, 1.13f, 0.2f)
                lineToRelative(3.92f, -1.83f)
                curveToRelative(0.38f, -0.18f, 0.54f, -0.62f, 0.36f, -1.0f)
                curveTo(20.75f, 8.34f, 20.31f, 8.17f, 19.93f, 8.35f)
                close()
                moveTo(6.0f, 8.0f)
                curveTo(5.45f, 8.0f, 5.0f, 7.55f, 5.0f, 7.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(7.0f, 7.55f, 6.55f, 8.0f, 6.0f, 8.0f)
                close()
                moveTo(11.11f, 18.0f)
                horizontalLineTo(9.17f)
                lineToRelative(-2.46f, -8.0f)
                horizontalLineToRelative(0.1f)
                lineTo(11.11f, 18.0f)
                close()
            }
        }
        return _precisionManufacturing!!
    }

private var _precisionManufacturing: ImageVector? = null
