/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Quickreply: ImageVector
    get() {
        if (_quickreply != null) {
            return _quickreply!!
        }
        _quickreply = materialIcon(name = "TwoTone.Quickreply") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 4.0f)
                lineToRelative(0.0f, 13.17f)
                lineToRelative(1.17f, -1.17f)
                lineToRelative(9.83f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                close()
            }
            materialPath {
                moveTo(5.17f, 16.0f)
                lineTo(4.0f, 17.17f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.01f, 2.9f, 2.01f, 4.0f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(5.17f)
                close()
            }
            materialPath {
                moveTo(19.0f, 23.0f)
                lineToRelative(3.5f, -7.0f)
                lineToRelative(-2.2f, 0.0f)
                lineToRelative(1.7f, -4.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(2.0f, 0.0f)
                close()
            }
        }
        return _quickreply!!
    }

private var _quickreply: ImageVector? = null
