/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Filled.NotListedLocation: ImageVector
    get() {
        if (_notListedLocation != null) {
            return _notListedLocation!!
        }
        _notListedLocation = materialIcon(name = "AutoMirrored.Filled.NotListedLocation", autoMirror
                = true) {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(8.14f, 2.0f, 5.0f, 5.14f, 5.0f, 9.0f)
                curveToRelative(0.0f, 5.25f, 7.0f, 13.0f, 7.0f, 13.0f)
                reflectiveCurveToRelative(7.0f, -7.75f, 7.0f, -13.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                close()
                moveTo(12.88f, 15.75f)
                horizontalLineToRelative(-1.75f)
                lineTo(11.13f, 14.0f)
                horizontalLineToRelative(1.75f)
                verticalLineToRelative(1.75f)
                close()
                moveTo(12.88f, 12.88f)
                horizontalLineToRelative(-1.75f)
                curveToRelative(0.0f, -2.84f, 2.62f, -2.62f, 2.62f, -4.38f)
                curveToRelative(0.0f, -0.96f, -0.79f, -1.75f, -1.75f, -1.75f)
                reflectiveCurveToRelative(-1.75f, 0.79f, -1.75f, 1.75f)
                lineTo(8.5f, 8.5f)
                curveTo(8.5f, 6.57f, 10.07f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(3.5f, 1.57f, 3.5f, 3.5f)
                curveToRelative(0.0f, 2.19f, -2.62f, 2.41f, -2.62f, 4.38f)
                close()
            }
        }
        return _notListedLocation!!
    }

private var _notListedLocation: ImageVector? = null
