/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.TwoTone.ContactSupport: ImageVector
    get() {
        if (_contactSupport != null) {
            return _contactSupport!!
        }
        _contactSupport = materialIcon(name = "AutoMirrored.TwoTone.ContactSupport", autoMirror =
                true) {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.5f, 3.0f)
                curveTo(7.36f, 3.0f, 4.0f, 6.36f, 4.0f, 10.5f)
                reflectiveCurveTo(7.36f, 18.0f, 11.5f, 18.0f)
                lineTo(13.0f, 18.0f)
                verticalLineToRelative(2.3f)
                curveToRelative(3.64f, -2.3f, 6.0f, -6.08f, 6.0f, -9.8f)
                curveTo(19.0f, 6.36f, 15.64f, 3.0f, 11.5f, 3.0f)
                close()
                moveTo(12.5f, 16.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(12.5f, 13.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -3.25f, 3.0f, -3.0f, 3.0f, -5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -2.21f, 1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                curveToRelative(0.0f, 2.5f, -3.0f, 2.75f, -3.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(11.5f, 1.0f)
                curveTo(6.26f, 1.0f, 2.0f, 5.26f, 2.0f, 10.5f)
                curveToRelative(0.0f, 5.07f, 3.99f, 9.23f, 9.0f, 9.49f)
                verticalLineToRelative(3.6f)
                lineToRelative(1.43f, -0.69f)
                curveTo(17.56f, 20.43f, 21.0f, 15.45f, 21.0f, 10.5f)
                curveTo(21.0f, 5.26f, 16.74f, 1.0f, 11.5f, 1.0f)
                close()
                moveTo(13.0f, 20.3f)
                lineTo(13.0f, 18.0f)
                horizontalLineToRelative(-1.5f)
                curveTo(7.36f, 18.0f, 4.0f, 14.64f, 4.0f, 10.5f)
                reflectiveCurveTo(7.36f, 3.0f, 11.5f, 3.0f)
                reflectiveCurveTo(19.0f, 6.36f, 19.0f, 10.5f)
                curveToRelative(0.0f, 3.73f, -2.36f, 7.51f, -6.0f, 9.8f)
                close()
                moveTo(10.5f, 14.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(11.5f, 4.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 2.0f, -3.0f, 1.75f, -3.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -2.25f, 3.0f, -2.5f, 3.0f, -5.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                close()
            }
        }
        return _contactSupport!!
    }

private var _contactSupport: ImageVector? = null
