/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FireExtinguisher: ImageVector
    get() {
        if (_fireExtinguisher != null) {
            return _fireExtinguisher!!
        }
        _fireExtinguisher = materialIcon(name = "Filled.FireExtinguisher") {
            materialPath {
                moveTo(7.0f, 19.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(7.0f, 18.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(17.0f, 3.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(-3.15f, -0.66f)
                curveToRelative(-0.01f, 0.0f, -0.01f, 0.01f, -0.02f, 0.02f)
                curveToRelative(1.55f, 0.62f, 2.72f, 1.98f, 3.07f, 3.64f)
                horizontalLineTo(7.1f)
                curveToRelative(0.34f, -1.66f, 1.52f, -3.02f, 3.07f, -3.64f)
                curveToRelative(-0.33f, -0.26f, -0.6f, -0.58f, -0.8f, -0.95f)
                lineTo(5.0f, 6.5f)
                verticalLineToRelative(-1.0f)
                lineToRelative(4.37f, -0.91f)
                curveTo(9.87f, 3.65f, 10.86f, 3.0f, 12.0f, 3.0f)
                curveToRelative(0.7f, 0.0f, 1.34f, 0.25f, 1.85f, 0.66f)
                lineTo(17.0f, 3.0f)
                close()
                moveTo(13.0f, 6.0f)
                curveToRelative(-0.03f, -0.59f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveTo(13.0f, 6.55f, 13.0f, 6.0f)
                close()
            }
        }
        return _fireExtinguisher!!
    }

private var _fireExtinguisher: ImageVector? = null
