/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FormatSize: ImageVector
    get() {
        if (_formatSize != null) {
            return _formatSize!!
        }
        _formatSize = materialIcon(name = "Rounded.FormatSize") {
            materialPath {
                moveTo(9.0f, 5.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(10.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(21.33f, 4.0f, 20.5f, 4.0f)
                horizontalLineToRelative(-10.0f)
                curveTo(9.67f, 4.0f, 9.0f, 4.67f, 9.0f, 5.5f)
                close()
                moveTo(4.5f, 12.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(5.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveTo(9.0f, 18.33f, 9.0f, 17.5f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(11.33f, 9.0f, 10.5f, 9.0f)
                horizontalLineToRelative(-6.0f)
                curveTo(3.67f, 9.0f, 3.0f, 9.67f, 3.0f, 10.5f)
                reflectiveCurveTo(3.67f, 12.0f, 4.5f, 12.0f)
                close()
            }
        }
        return _formatSize!!
    }

private var _formatSize: ImageVector? = null
