/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Pages: ImageVector
    get() {
        if (_pages != null) {
            return _pages!!
        }
        _pages = materialIcon(name = "Rounded.Pages") {
            materialPath {
                moveTo(3.0f, 5.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(5.0f)
                lineToRelative(-0.6f, -2.38f)
                curveToRelative(-0.18f, -0.74f, 0.48f, -1.4f, 1.22f, -1.22f)
                lineTo(11.0f, 8.0f)
                lineTo(11.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                close()
                moveTo(8.0f, 13.0f)
                lineTo(3.0f, 13.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                lineToRelative(-2.38f, 0.6f)
                curveToRelative(-0.73f, 0.18f, -1.4f, -0.48f, -1.21f, -1.21f)
                lineTo(8.0f, 13.0f)
                close()
                moveTo(15.38f, 16.6f)
                lineTo(13.0f, 16.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(0.6f, 2.38f)
                curveToRelative(0.18f, 0.74f, -0.48f, 1.4f, -1.22f, 1.22f)
                close()
                moveTo(19.0f, 3.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(5.0f)
                lineToRelative(2.38f, -0.6f)
                curveToRelative(0.73f, -0.18f, 1.4f, 0.48f, 1.21f, 1.21f)
                lineTo(16.0f, 11.0f)
                horizontalLineToRelative(5.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _pages!!
    }

private var _pages: ImageVector? = null
