/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PowerOff: ImageVector
    get() {
        if (_powerOff != null) {
            return _powerOff!!
        }
        _powerOff = materialIcon(name = "Rounded.PowerOff") {
            materialPath {
                moveTo(18.0f, 13.66f)
                lineTo(18.0f, 8.99f)
                curveToRelative(0.0f, -1.0f, -1.01f, -2.0f, -2.0f, -1.99f)
                lineTo(16.0f, 4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-3.88f)
                lineToRelative(7.63f, 7.63f)
                curveToRelative(0.15f, -0.3f, 0.25f, -0.63f, 0.25f, -0.97f)
                close()
                moveTo(10.0f, 4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.88f)
                lineToRelative(2.0f, 2.0f)
                lineTo(10.0f, 4.0f)
                close()
                moveTo(20.15f, 19.86f)
                lineToRelative(-7.66f, -7.66f)
                lineToRelative(-5.1f, -5.1f)
                lineToRelative(-2.56f, -2.56f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.63f, 2.63f)
                curveToRelative(-0.03f, 0.13f, -0.05f, 0.27f, -0.05f, 0.41f)
                verticalLineToRelative(4.66f)
                curveToRelative(0.0f, 0.53f, 0.21f, 1.04f, 0.58f, 1.41f)
                lineTo(9.5f, 18.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(0.48f, -0.48f)
                lineToRelative(3.76f, 3.76f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.03f, 0.0f, -1.42f)
                close()
            }
        }
        return _powerOff!!
    }

private var _powerOff: ImageVector? = null
