/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Support: ImageVector
    get() {
        if (_support != null) {
            return _support!!
        }
        _support = materialIcon(name = "Rounded.Support") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(19.46f, 9.12f)
                lineToRelative(-2.78f, 1.15f)
                curveToRelative(-0.51f, -1.36f, -1.58f, -2.44f, -2.95f, -2.94f)
                lineToRelative(1.15f, -2.78f)
                curveTo(16.98f, 5.35f, 18.65f, 7.02f, 19.46f, 9.12f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(13.66f, 15.0f, 12.0f, 15.0f)
                close()
                moveTo(9.13f, 4.54f)
                lineToRelative(1.17f, 2.78f)
                curveToRelative(-1.38f, 0.5f, -2.47f, 1.59f, -2.98f, 2.97f)
                lineTo(4.54f, 9.13f)
                curveTo(5.35f, 7.02f, 7.02f, 5.35f, 9.13f, 4.54f)
                close()
                moveTo(4.54f, 14.87f)
                lineToRelative(2.78f, -1.15f)
                curveToRelative(0.51f, 1.38f, 1.59f, 2.46f, 2.97f, 2.96f)
                lineToRelative(-1.17f, 2.78f)
                curveTo(7.02f, 18.65f, 5.35f, 16.98f, 4.54f, 14.87f)
                close()
                moveTo(14.88f, 19.46f)
                lineToRelative(-1.15f, -2.78f)
                curveToRelative(1.37f, -0.51f, 2.45f, -1.59f, 2.95f, -2.97f)
                lineToRelative(2.78f, 1.17f)
                curveTo(18.65f, 16.98f, 16.98f, 18.65f, 14.88f, 19.46f)
                close()
            }
        }
        return _support!!
    }

private var _support: ImageVector? = null
