/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WbIncandescent: ImageVector
    get() {
        if (_wbIncandescent != null) {
            return _wbIncandescent!!
        }
        _wbIncandescent = materialIcon(name = "Rounded.WbIncandescent") {
            materialPath {
                moveTo(4.25f, 19.79f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.39f, -0.39f)
                curveToRelative(0.39f, -0.39f, 0.38f, -1.02f, 0.0f, -1.4f)
                lineToRelative(-0.01f, -0.01f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.39f, 0.39f)
                curveToRelative(-0.38f, 0.4f, -0.38f, 1.02f, 0.01f, 1.41f)
                close()
                moveTo(11.99f, 23.0f)
                lineTo(12.0f, 23.0f)
                curveToRelative(0.55f, 0.0f, 0.99f, -0.44f, 0.99f, -0.99f)
                verticalLineToRelative(-0.96f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                horizontalLineToRelative(-0.01f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                verticalLineToRelative(0.96f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                close()
                moveTo(3.01f, 11.05f)
                lineTo(1.99f, 11.05f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                lineTo(3.0f, 13.04f)
                curveToRelative(0.55f, 0.0f, 0.99f, -0.44f, 0.99f, -0.99f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.01f, -0.55f, -0.43f, -0.99f, -0.98f, -0.99f)
                close()
                moveTo(15.0f, 6.86f)
                lineTo(15.0f, 3.05f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.81f)
                curveToRelative(-2.04f, 1.18f, -3.32f, 3.52f, -2.93f, 6.13f)
                curveToRelative(0.4f, 2.61f, 2.56f, 4.7f, 5.18f, 5.02f)
                curveToRelative(3.64f, 0.44f, 6.75f, -2.4f, 6.75f, -5.95f)
                curveToRelative(0.0f, -2.23f, -1.21f, -4.16f, -3.0f, -5.2f)
                close()
                moveTo(20.0f, 12.04f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                lineTo(22.0f, 13.04f)
                curveToRelative(0.55f, 0.0f, 0.99f, -0.44f, 0.99f, -0.99f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                horizontalLineToRelative(-1.01f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                close()
                moveTo(17.94f, 19.41f)
                lineToRelative(0.39f, 0.39f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-0.39f, -0.39f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.38f, -1.4f, 0.0f)
                curveToRelative(-0.4f, 0.4f, -0.4f, 1.02f, -0.01f, 1.41f)
                close()
            }
        }
        return _wbIncandescent!!
    }

private var _wbIncandescent: ImageVector? = null
