/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Rocket: ImageVector
    get() {
        if (_rocket != null) {
            return _rocket!!
        }
        _rocket = materialIcon(name = "Sharp.Rocket") {
            materialPath {
                moveTo(12.0f, 2.5f)
                curveToRelative(0.0f, 0.0f, 4.5f, 2.04f, 4.5f, 10.5f)
                curveToRelative(0.0f, 2.49f, -1.04f, 5.57f, -1.6f, 7.0f)
                horizontalLineTo(9.1f)
                curveToRelative(-0.56f, -1.43f, -1.6f, -4.51f, -1.6f, -7.0f)
                curveTo(7.5f, 4.54f, 12.0f, 2.5f, 12.0f, 2.5f)
                close()
                moveTo(14.0f, 11.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveTo(14.0f, 12.1f, 14.0f, 11.0f)
                close()
                moveTo(7.69f, 20.52f)
                curveToRelative(-0.48f, -1.23f, -1.52f, -4.17f, -1.67f, -6.87f)
                lineTo(4.0f, 15.0f)
                verticalLineToRelative(7.0f)
                lineTo(7.69f, 20.52f)
                close()
                moveTo(20.0f, 22.0f)
                verticalLineToRelative(-7.0f)
                lineToRelative(-2.02f, -1.35f)
                curveToRelative(-0.15f, 2.69f, -1.2f, 5.64f, -1.67f, 6.87f)
                lineTo(20.0f, 22.0f)
                close()
            }
        }
        return _rocket!!
    }

private var _rocket: ImageVector? = null
