/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideoCameraBack: ImageVector
    get() {
        if (_videoCameraBack != null) {
            return _videoCameraBack!!
        }
        _videoCameraBack = materialIcon(name = "Sharp.VideoCameraBack") {
            materialPath {
                moveTo(18.0f, 10.48f)
                verticalLineTo(4.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-6.48f)
                lineToRelative(4.0f, 3.98f)
                verticalLineToRelative(-11.0f)
                lineTo(18.0f, 10.48f)
                close()
                moveTo(5.0f, 16.0f)
                lineToRelative(2.38f, -3.17f)
                lineTo(9.0f, 15.0f)
                lineToRelative(2.62f, -3.5f)
                lineTo(15.0f, 16.0f)
                horizontalLineTo(5.0f)
                close()
            }
        }
        return _videoCameraBack!!
    }

private var _videoCameraBack: ImageVector? = null
