/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WaterDrop: ImageVector
    get() {
        if (_waterDrop != null) {
            return _waterDrop!!
        }
        _waterDrop = materialIcon(name = "Sharp.WaterDrop") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveToRelative(-5.33f, 4.55f, -8.0f, 8.48f, -8.0f, 11.8f)
                curveToRelative(0.0f, 4.98f, 3.8f, 8.2f, 8.0f, 8.2f)
                reflectiveCurveToRelative(8.0f, -3.22f, 8.0f, -8.2f)
                curveTo(20.0f, 10.48f, 17.33f, 6.55f, 12.0f, 2.0f)
                close()
                moveTo(13.0f, 18.91f)
                curveTo(12.68f, 18.97f, 12.35f, 19.0f, 12.0f, 19.0f)
                curveToRelative(-2.69f, 0.0f, -4.88f, -1.94f, -5.0f, -5.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.08f, 2.07f, 1.5f, 3.5f, 3.5f, 3.5f)
                curveToRelative(0.35f, 0.0f, 0.69f, -0.04f, 1.0f, -0.13f)
                verticalLineTo(18.91f)
                close()
            }
        }
        return _waterDrop!!
    }

private var _waterDrop: ImageVector? = null
