/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SwitchAccessShortcut: ImageVector
    get() {
        if (_switchAccessShortcut != null) {
            return _switchAccessShortcut!!
        }
        _switchAccessShortcut = materialIcon(name = "TwoTone.SwitchAccessShortcut") {
            materialPath {
                moveTo(7.06f, 8.94f)
                lineTo(5.0f, 8.0f)
                lineToRelative(2.06f, -0.94f)
                lineTo(8.0f, 5.0f)
                lineToRelative(0.94f, 2.06f)
                lineTo(11.0f, 8.0f)
                lineTo(8.94f, 8.94f)
                lineTo(8.0f, 11.0f)
                lineTo(7.06f, 8.94f)
                close()
                moveTo(8.0f, 21.0f)
                lineToRelative(0.94f, -2.06f)
                lineTo(11.0f, 18.0f)
                lineToRelative(-2.06f, -0.94f)
                lineTo(8.0f, 15.0f)
                lineToRelative(-0.94f, 2.06f)
                lineTo(5.0f, 18.0f)
                lineToRelative(2.06f, 0.94f)
                lineTo(8.0f, 21.0f)
                close()
                moveTo(4.37f, 12.37f)
                lineTo(3.0f, 13.0f)
                lineToRelative(1.37f, 0.63f)
                lineTo(5.0f, 15.0f)
                lineToRelative(0.63f, -1.37f)
                lineTo(7.0f, 13.0f)
                lineToRelative(-1.37f, -0.63f)
                lineTo(5.0f, 11.0f)
                lineTo(4.37f, 12.37f)
                close()
                moveTo(12.0f, 12.0f)
                curveToRelative(0.0f, -2.73f, 1.08f, -5.27f, 2.75f, -7.25f)
                lineTo(12.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(-2.82f, -2.82f)
                curveTo(14.84f, 7.82f, 14.0f, 9.88f, 14.0f, 12.0f)
                curveToRelative(0.0f, 3.32f, 2.1f, 6.36f, 5.0f, 7.82f)
                lineTo(19.0f, 22.0f)
                curveTo(14.91f, 20.41f, 12.0f, 16.35f, 12.0f, 12.0f)
                close()
            }
        }
        return _switchAccessShortcut!!
    }

private var _switchAccessShortcut: ImageVector? = null
