/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MinorCrash: ImageVector
    get() {
        if (_minorCrash != null) {
            return _minorCrash!!
        }
        _minorCrash = materialIcon(name = "TwoTone.MinorCrash") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 15.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(5.0f)
                close()
                moveTo(7.5f, 19.0f)
                curveTo(6.67f, 19.0f, 6.0f, 18.33f, 6.0f, 17.5f)
                reflectiveCurveTo(6.67f, 16.0f, 7.5f, 16.0f)
                reflectiveCurveTo(9.0f, 16.67f, 9.0f, 17.5f)
                reflectiveCurveTo(8.33f, 19.0f, 7.5f, 19.0f)
                close()
                moveTo(16.5f, 19.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(17.33f, 19.0f, 16.5f, 19.0f)
                close()
            }
            materialPath {
                moveTo(9.41f, 5.0f)
                lineTo(8.0f, 6.41f)
                lineToRelative(-3.0f, -3.0f)
                lineTo(6.41f, 2.0f)
                lineTo(9.41f, 5.0f)
                close()
                moveTo(19.0f, 3.41f)
                lineTo(17.59f, 2.0f)
                lineToRelative(-3.0f, 3.0f)
                lineTo(16.0f, 6.41f)
                lineTo(19.0f, 3.41f)
                close()
                moveTo(13.0f, 0.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(0.0f)
                close()
                moveTo(21.0f, 15.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-8.0f)
                lineToRelative(2.08f, -5.99f)
                curveTo(5.29f, 8.42f, 5.84f, 8.0f, 6.5f, 8.0f)
                horizontalLineToRelative(11.0f)
                curveToRelative(0.66f, 0.0f, 1.22f, 0.42f, 1.42f, 1.01f)
                lineTo(21.0f, 15.0f)
                close()
                moveTo(5.81f, 13.0f)
                horizontalLineToRelative(12.38f)
                lineToRelative(-1.04f, -3.0f)
                horizontalLineTo(6.85f)
                lineTo(5.81f, 13.0f)
                close()
                moveTo(19.0f, 15.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(15.0f)
                close()
                moveTo(7.5f, 19.0f)
                curveTo(8.33f, 19.0f, 9.0f, 18.33f, 9.0f, 17.5f)
                reflectiveCurveTo(8.33f, 16.0f, 7.5f, 16.0f)
                reflectiveCurveTo(6.0f, 16.67f, 6.0f, 17.5f)
                reflectiveCurveTo(6.67f, 19.0f, 7.5f, 19.0f)
                close()
                moveTo(16.5f, 19.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(17.33f, 16.0f, 16.5f, 16.0f)
                reflectiveCurveTo(15.0f, 16.67f, 15.0f, 17.5f)
                reflectiveCurveTo(15.67f, 19.0f, 16.5f, 19.0f)
                close()
            }
        }
        return _minorCrash!!
    }

private var _minorCrash: ImageVector? = null
