/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.NextPlan",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.NextPlan",
            "androidx.compose.material.icons.automirrored.twotone.NextPlan"),
)
public val Icons.TwoTone.NextPlan: ImageVector
    get() {
        if (_nextPlan != null) {
            return _nextPlan!!
        }
        _nextPlan = materialIcon(name = "TwoTone.NextPlan") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                reflectiveCurveTo(16.42f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(13.0f, 14.0f)
                lineToRelative(2.26f, -2.26f)
                curveTo(14.35f, 10.68f, 13.01f, 10.0f, 11.5f, 10.0f)
                curveToRelative(-2.37f, 0.0f, -4.35f, 1.66f, -4.86f, 3.88f)
                lineToRelative(-0.96f, -0.32f)
                curveTo(6.32f, 10.95f, 8.68f, 9.0f, 11.5f, 9.0f)
                curveToRelative(1.78f, 0.0f, 3.37f, 0.79f, 4.47f, 2.03f)
                lineTo(18.0f, 9.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(13.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveTo(16.42f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(15.97f, 11.03f)
                curveTo(14.87f, 9.79f, 13.28f, 9.0f, 11.5f, 9.0f)
                curveToRelative(-2.82f, 0.0f, -5.18f, 1.95f, -5.82f, 4.56f)
                lineToRelative(0.96f, 0.32f)
                curveTo(7.15f, 11.66f, 9.13f, 10.0f, 11.5f, 10.0f)
                curveToRelative(1.51f, 0.0f, 2.85f, 0.68f, 3.76f, 1.74f)
                lineTo(13.0f, 14.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.0f)
                lineTo(15.97f, 11.03f)
                close()
            }
        }
        return _nextPlan!!
    }

private var _nextPlan: ImageVector? = null
