/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DonutLarge: ImageVector
    get() {
        if (_donutLarge != null) {
            return _donutLarge!!
        }
        _donutLarge = materialIcon(name = "Filled.DonutLarge") {
            materialPath {
                moveTo(11.0f, 5.08f)
                verticalLineTo(2.0f)
                curveTo(6.0f, 2.5f, 2.0f, 6.81f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.0f, 9.5f, 9.0f, 10.0f)
                verticalLineToRelative(-3.08f)
                curveToRelative(-3.0f, -0.48f, -6.0f, -3.4f, -6.0f, -6.92f)
                reflectiveCurveTo(8.0f, 5.56f, 11.0f, 5.08f)
                close()
                moveTo(18.97f, 11.0f)
                horizontalLineTo(22.0f)
                curveToRelative(-0.47f, -5.0f, -4.0f, -8.53f, -9.0f, -9.0f)
                verticalLineToRelative(3.08f)
                curveTo(16.0f, 5.51f, 18.54f, 8.0f, 18.97f, 11.0f)
                close()
                moveTo(13.0f, 18.92f)
                verticalLineTo(22.0f)
                curveToRelative(5.0f, -0.47f, 8.53f, -4.0f, 9.0f, -9.0f)
                horizontalLineToRelative(-3.03f)
                curveTo(18.54f, 16.0f, 16.0f, 18.49f, 13.0f, 18.92f)
                close()
            }
        }
        return _donutLarge!!
    }

private var _donutLarge: ImageVector? = null
