/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.GeneratingTokens: ImageVector
    get() {
        if (_generatingTokens != null) {
            return _generatingTokens!!
        }
        _generatingTokens = materialIcon(name = "Filled.GeneratingTokens") {
            materialPath {
                moveTo(9.0f, 4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                curveTo(17.0f, 7.58f, 13.42f, 4.0f, 9.0f, 4.0f)
                close()
                moveTo(12.0f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(20.25f, 3.75f)
                lineTo(23.0f, 5.0f)
                lineToRelative(-2.75f, 1.25f)
                lineTo(19.0f, 9.0f)
                lineToRelative(-1.25f, -2.75f)
                lineTo(15.0f, 5.0f)
                lineToRelative(2.75f, -1.25f)
                lineTo(19.0f, 1.0f)
                lineTo(20.25f, 3.75f)
                close()
                moveTo(20.25f, 17.75f)
                lineTo(23.0f, 19.0f)
                lineToRelative(-2.75f, 1.25f)
                lineTo(19.0f, 23.0f)
                lineToRelative(-1.25f, -2.75f)
                lineTo(15.0f, 19.0f)
                lineToRelative(2.75f, -1.25f)
                lineTo(19.0f, 15.0f)
                lineTo(20.25f, 17.75f)
                close()
            }
        }
        return _generatingTokens!!
    }

private var _generatingTokens: ImageVector? = null
