/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled._12mp: ImageVector
    get() {
        if (__12mp != null) {
            return __12mp!!
        }
        __12mp = materialIcon(name = "Filled._12mp") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(12.0f, 18.5f)
                horizontalLineToRelative(-1.5f)
                lineTo(10.5f, 14.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(3.0f)
                lineTo(8.0f, 17.0f)
                verticalLineToRelative(-3.0f)
                lineTo(7.0f, 14.0f)
                verticalLineToRelative(4.5f)
                lineTo(5.5f, 18.5f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                lineTo(11.0f, 12.5f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                close()
                moveTo(15.5f, 18.5f)
                lineTo(14.0f, 18.5f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                lineTo(18.5f, 16.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.5f)
                close()
                moveTo(10.0f, 5.5f)
                verticalLineToRelative(6.0f)
                lineTo(8.5f, 11.5f)
                lineTo(8.5f, 7.0f)
                lineTo(7.0f, 7.0f)
                lineTo(7.0f, 5.5f)
                horizontalLineToRelative(3.0f)
                close()
                moveTo(15.5f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(1.5f)
                lineTo(12.0f, 11.5f)
                lineTo(12.0f, 9.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.0f)
                lineTo(15.0f, 7.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(12.0f, 5.5f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                lineTo(16.5f, 8.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(15.5f, 14.0f)
                lineTo(17.0f, 14.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-1.5f)
                close()
            }
        }
        return __12mp!!
    }

private var __12mp: ImageVector? = null
