/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ScreenRotationAlt: ImageVector
    get() {
        if (_screenRotationAlt != null) {
            return _screenRotationAlt!!
        }
        _screenRotationAlt = materialIcon(name = "Outlined.ScreenRotationAlt") {
            materialPath {
                moveTo(4.0f, 7.59f)
                lineToRelative(5.0f, -5.0f)
                curveToRelative(0.78f, -0.78f, 2.05f, -0.78f, 2.83f, 0.0f)
                lineTo(20.24f, 11.0f)
                horizontalLineToRelative(-2.83f)
                lineTo(10.4f, 4.0f)
                lineTo(5.41f, 9.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.59f)
                close()
                moveTo(20.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.59f)
                lineToRelative(-4.99f, 5.0f)
                lineToRelative(-7.01f, -7.0f)
                horizontalLineTo(3.76f)
                lineToRelative(8.41f, 8.41f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(5.0f, -5.0f)
                verticalLineTo(19.0f)
                close()
            }
        }
        return _screenRotationAlt!!
    }

private var _screenRotationAlt: ImageVector? = null
