/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ScubaDiving: ImageVector
    get() {
        if (_scubaDiving != null) {
            return _scubaDiving!!
        }
        _scubaDiving = materialIcon(name = "Rounded.ScubaDiving") {
            materialPath {
                moveTo(1.0f, 13.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(1.0f, 14.1f, 1.0f, 13.0f)
                close()
                moveTo(8.89f, 10.11f)
                lineToRelative(3.56f, -0.95f)
                curveToRelative(0.53f, -0.14f, 0.85f, -0.69f, 0.71f, -1.22f)
                lineTo(12.9f, 6.97f)
                curveToRelative(-0.14f, -0.53f, -0.69f, -0.85f, -1.22f, -0.71f)
                lineTo(8.11f, 7.21f)
                curveToRelative(-0.8f, 0.21f, -1.28f, 1.04f, -1.06f, 1.84f)
                lineToRelative(0.0f, 0.0f)
                curveTo(7.27f, 9.85f, 8.09f, 10.33f, 8.89f, 10.11f)
                close()
                moveTo(22.52f, 2.52f)
                curveToRelative(-0.29f, -0.29f, -0.75f, -0.29f, -1.04f, 0.0f)
                lineTo(19.0f, 5.0f)
                lineToRelative(-2.0f, 4.0f)
                lineToRelative(-9.48f, 2.87f)
                curveToRelative(-0.82f, 0.2f, -1.39f, 0.89f, -1.5f, 1.68f)
                lineTo(5.24f, 18.0f)
                lineTo(3.0f, 21.0f)
                curveToRelative(-0.33f, 0.44f, -0.24f, 1.07f, 0.2f, 1.4f)
                curveToRelative(0.44f, 0.33f, 1.07f, 0.24f, 1.4f, -0.2f)
                lineTo(7.0f, 19.0f)
                lineToRelative(1.14f, -3.14f)
                lineToRelative(5.57f, -1.77f)
                curveToRelative(0.19f, -0.06f, 0.38f, -0.15f, 0.54f, -0.27f)
                lineToRelative(4.2f, -2.94f)
                curveToRelative(0.36f, -0.25f, 0.62f, -0.61f, 0.75f, -1.02f)
                lineTo(20.5f, 5.9f)
                lineToRelative(2.06f, -2.38f)
                curveTo(22.81f, 3.22f, 22.79f, 2.79f, 22.52f, 2.52f)
                close()
            }
        }
        return _scubaDiving!!
    }

private var _scubaDiving: ImageVector? = null
