/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Stroller: ImageVector
    get() {
        if (_stroller != null) {
            return _stroller!!
        }
        _stroller = materialIcon(name = "Rounded.Stroller") {
            materialPath {
                moveTo(18.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(18.0f, 18.9f, 18.0f, 20.0f)
                close()
                moveTo(6.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 18.0f, 6.0f, 18.0f)
                close()
                moveTo(14.3f, 4.1f)
                curveTo(13.03f, 3.4f, 11.56f, 3.0f, 10.0f, 3.0f)
                curveTo(8.49f, 3.0f, 7.07f, 3.38f, 5.83f, 4.03f)
                curveTo(5.24f, 4.34f, 5.15f, 5.15f, 5.61f, 5.61f)
                lineToRelative(3.99f, 3.99f)
                lineTo(14.3f, 4.1f)
                close()
                moveTo(21.94f, 5.83f)
                curveTo(21.65f, 4.22f, 20.3f, 3.0f, 18.65f, 3.0f)
                curveToRelative(-1.66f, 0.0f, -2.54f, 1.27f, -3.18f, 2.03f)
                lineTo(6.71f, 15.31f)
                curveToRelative(-0.55f, 0.65f, -0.09f, 1.65f, 0.76f, 1.65f)
                horizontalLineTo(15.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.27f)
                curveTo(17.58f, 5.59f, 17.97f, 5.0f, 18.65f, 5.0f)
                curveToRelative(0.68f, 0.0f, 1.22f, 0.52f, 1.33f, 1.21f)
                lineToRelative(0.0f, 0.0f)
                curveTo(20.08f, 6.66f, 20.48f, 7.0f, 20.96f, 7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveTo(21.96f, 5.94f, 21.95f, 5.89f, 21.94f, 5.83f)
                lineTo(21.94f, 5.83f)
                close()
            }
        }
        return _stroller!!
    }

private var _stroller: ImageVector? = null
