/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.UnfoldMoreDouble: ImageVector
    get() {
        if (_unfoldMoreDouble != null) {
            return _unfoldMoreDouble!!
        }
        _unfoldMoreDouble = materialIcon(name = "Rounded.UnfoldMoreDouble") {
            materialPath {
                moveTo(9.53f, 5.29f)
                lineTo(12.0f, 2.83f)
                lineToRelative(2.46f, 2.46f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                reflectiveCurveToRelative(0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(12.7f, 0.7f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(8.12f, 3.88f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                reflectiveCurveTo(9.14f, 5.68f, 9.53f, 5.29f)
                close()
            }
            materialPath {
                moveTo(9.53f, 10.29f)
                lineTo(12.0f, 7.83f)
                lineToRelative(2.46f, 2.46f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                reflectiveCurveToRelative(0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(12.7f, 5.7f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(8.12f, 8.88f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                reflectiveCurveTo(9.14f, 10.68f, 9.53f, 10.29f)
                close()
            }
            materialPath {
                moveTo(14.47f, 13.71f)
                lineTo(12.0f, 16.17f)
                lineToRelative(-2.46f, -2.46f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.17f, 3.18f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.17f, -3.18f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveTo(15.49f, 13.32f, 14.86f, 13.32f, 14.47f, 13.71f)
                close()
            }
            materialPath {
                moveTo(14.47f, 18.72f)
                lineTo(12.0f, 21.17f)
                lineToRelative(-2.46f, -2.46f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.17f, 3.18f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.17f, -3.17f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                reflectiveCurveTo(14.86f, 18.33f, 14.47f, 18.72f)
                close()
            }
        }
        return _unfoldMoreDouble!!
    }

private var _unfoldMoreDouble: ImageVector? = null
