/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SpeakerPhone: ImageVector
    get() {
        if (_speakerPhone != null) {
            return _speakerPhone!!
        }
        _speakerPhone = materialIcon(name = "TwoTone.SpeakerPhone") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.0f, 12.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(8.0f)
                horizontalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 1.0f)
                curveTo(8.98f, 1.0f, 6.24f, 2.23f, 4.25f, 4.21f)
                lineToRelative(1.41f, 1.41f)
                curveTo(7.28f, 4.0f, 9.53f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveToRelative(4.72f, 1.0f, 6.34f, 2.62f)
                lineToRelative(1.41f, -1.41f)
                curveTo(17.76f, 2.23f, 15.02f, 1.0f, 12.0f, 1.0f)
                close()
                moveTo(7.0f, 7.07f)
                lineTo(8.43f, 8.5f)
                curveToRelative(0.91f, -0.91f, 2.18f, -1.48f, 3.57f, -1.48f)
                reflectiveCurveToRelative(2.66f, 0.57f, 3.57f, 1.48f)
                lineTo(17.0f, 7.07f)
                curveTo(15.72f, 5.79f, 13.95f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(-3.72f, 0.79f, -5.0f, 2.07f)
                close()
                moveTo(14.86f, 10.01f)
                lineTo(9.14f, 10.0f)
                curveTo(8.51f, 10.0f, 8.0f, 10.51f, 8.0f, 11.14f)
                verticalLineToRelative(9.71f)
                curveToRelative(0.0f, 0.63f, 0.51f, 1.14f, 1.14f, 1.14f)
                horizontalLineToRelative(5.71f)
                curveToRelative(0.63f, 0.0f, 1.14f, -0.51f, 1.14f, -1.14f)
                verticalLineToRelative(-9.71f)
                curveToRelative(0.01f, -0.63f, -0.5f, -1.13f, -1.13f, -1.13f)
                close()
                moveTo(15.0f, 20.0f)
                lineTo(9.0f, 20.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(8.0f)
                close()
            }
        }
        return _speakerPhone!!
    }

private var _speakerPhone: ImageVector? = null
