/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NaturePeople: ImageVector
    get() {
        if (_naturePeople != null) {
            return _naturePeople!!
        }
        _naturePeople = materialIcon(name = "Sharp.NaturePeople") {
            materialPath {
                moveTo(22.17f, 9.17f)
                curveToRelative(0.0f, -3.91f, -3.19f, -7.06f, -7.11f, -7.0f)
                curveToRelative(-3.83f, 0.06f, -6.99f, 3.37f, -6.88f, 7.19f)
                curveToRelative(0.09f, 3.38f, 2.58f, 6.16f, 5.83f, 6.7f)
                verticalLineTo(20.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-3.88f)
                curveToRelative(3.47f, -0.41f, 6.17f, -3.36f, 6.17f, -6.95f)
                close()
                moveTo(4.5f, 11.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(5.33f, 8.0f, 4.5f, 8.0f)
                reflectiveCurveTo(3.0f, 8.67f, 3.0f, 9.5f)
                reflectiveCurveTo(3.67f, 11.0f, 4.5f, 11.0f)
                close()
            }
        }
        return _naturePeople!!
    }

private var _naturePeople: ImageVector? = null
