/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EscalatorWarning: ImageVector
    get() {
        if (_escalatorWarning != null) {
            return _escalatorWarning!!
        }
        _escalatorWarning = materialIcon(name = "Sharp.EscalatorWarning") {
            materialPath {
                moveTo(6.5f, 2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveTo(5.4f, 2.0f, 6.5f, 2.0f)
                close()
                moveTo(15.5f, 9.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(17.83f, 8.0f, 17.0f, 8.0f)
                reflectiveCurveTo(15.5f, 8.67f, 15.5f, 9.5f)
                close()
                moveTo(14.21f, 12.86f)
                lineToRelative(-0.92f, 1.32f)
                lineTo(9.72f, 8.0f)
                curveTo(9.37f, 7.38f, 8.71f, 7.0f, 7.99f, 7.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(11.61f)
                lineTo(12.03f, 16.0f)
                horizontalLineToRelative(2.2f)
                lineTo(15.0f, 14.9f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(-4.15f)
                curveTo(15.19f, 12.0f, 14.58f, 12.32f, 14.21f, 12.86f)
                close()
            }
        }
        return _escalatorWarning!!
    }

private var _escalatorWarning: ImageVector? = null
