/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.InvertColors: ImageVector
    get() {
        if (_invertColors != null) {
            return _invertColors!!
        }
        _invertColors = materialIcon(name = "TwoTone.InvertColors") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.75f, 8.99f)
                curveTo(6.62f, 10.1f, 6.0f, 11.57f, 6.0f, 13.13f)
                curveTo(6.0f, 16.37f, 8.69f, 19.0f, 12.0f, 19.0f)
                lineToRelative(0.0f, -14.19f)
                lineTo(7.75f, 8.99f)
                close()
            }
            materialPath {
                moveTo(17.65f, 7.56f)
                lineTo(17.65f, 7.56f)
                lineTo(12.0f, 2.0f)
                lineTo(6.35f, 7.56f)
                lineToRelative(0.0f, 0.0f)
                curveTo(4.9f, 8.99f, 4.0f, 10.96f, 4.0f, 13.13f)
                curveTo(4.0f, 17.48f, 7.58f, 21.0f, 12.0f, 21.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, -3.52f, 8.0f, -7.87f)
                curveTo(20.0f, 10.96f, 19.1f, 8.99f, 17.65f, 7.56f)
                close()
                moveTo(6.0f, 13.13f)
                curveToRelative(0.0f, -1.56f, 0.62f, -3.03f, 1.75f, -4.14f)
                lineTo(12.0f, 4.81f)
                lineTo(12.0f, 19.0f)
                curveTo(8.69f, 19.0f, 6.0f, 16.37f, 6.0f, 13.13f)
                close()
            }
        }
        return _invertColors!!
    }

private var _invertColors: ImageVector? = null
