/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TempleHindu: ImageVector
    get() {
        if (_templeHindu != null) {
            return _templeHindu!!
        }
        _templeHindu = materialIcon(name = "Outlined.TempleHindu") {
            materialPath {
                moveTo(20.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(15.0f, 3.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.03f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.12f)
                lineTo(6.0f, 13.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(15.31f, 11.0f)
                horizontalLineTo(8.69f)
                lineToRelative(0.6f, -2.0f)
                horizontalLineToRelative(5.42f)
                lineTo(15.31f, 11.0f)
                close()
                moveTo(14.11f, 7.0f)
                horizontalLineTo(9.89f)
                lineToRelative(0.6f, -2.0f)
                horizontalLineToRelative(3.02f)
                lineTo(14.11f, 7.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(3.49f)
                lineToRelative(0.6f, -2.0f)
                horizontalLineToRelative(7.82f)
                lineToRelative(0.6f, 2.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _templeHindu!!
    }

private var _templeHindu: ImageVector? = null
