/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Filled.MergeType",
    ReplaceWith( "Icons.AutoMirrored.Filled.MergeType",
            "androidx.compose.material.icons.automirrored.filled.MergeType"),
)
public val Icons.Filled.MergeType: ImageVector
    get() {
        if (_mergeType != null) {
            return _mergeType!!
        }
        _mergeType = materialIcon(name = "Filled.MergeType") {
            materialPath {
                moveTo(17.0f, 20.41f)
                lineTo(18.41f, 19.0f)
                lineTo(15.0f, 15.59f)
                lineTo(13.59f, 17.0f)
                lineTo(17.0f, 20.41f)
                close()
                moveTo(7.5f, 8.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(5.59f)
                lineTo(5.59f, 19.0f)
                lineTo(7.0f, 20.41f)
                lineToRelative(6.0f, -6.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(3.5f)
                lineTo(12.0f, 3.5f)
                lineTo(7.5f, 8.0f)
                close()
            }
        }
        return _mergeType!!
    }

private var _mergeType: ImageVector? = null
