/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MilitaryTech: ImageVector
    get() {
        if (_militaryTech != null) {
            return _militaryTech!!
        }
        _militaryTech = materialIcon(name = "Filled.MilitaryTech") {
            materialPath {
                moveTo(17.0f, 10.43f)
                verticalLineTo(2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(8.43f)
                curveToRelative(0.0f, 0.35f, 0.18f, 0.68f, 0.49f, 0.86f)
                lineToRelative(4.18f, 2.51f)
                lineToRelative(-0.99f, 2.34f)
                lineToRelative(-3.41f, 0.29f)
                lineToRelative(2.59f, 2.24f)
                lineTo(9.07f, 22.0f)
                lineTo(12.0f, 20.23f)
                lineTo(14.93f, 22.0f)
                lineToRelative(-0.78f, -3.33f)
                lineToRelative(2.59f, -2.24f)
                lineToRelative(-3.41f, -0.29f)
                lineToRelative(-0.99f, -2.34f)
                lineToRelative(4.18f, -2.51f)
                curveTo(16.82f, 11.11f, 17.0f, 10.79f, 17.0f, 10.43f)
                close()
                moveTo(13.0f, 12.23f)
                lineToRelative(-1.0f, 0.6f)
                lineToRelative(-1.0f, -0.6f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.23f)
                close()
            }
        }
        return _militaryTech!!
    }

private var _militaryTech: ImageVector? = null
