/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalLaundryService: ImageVector
    get() {
        if (_localLaundryService != null) {
            return _localLaundryService!!
        }
        _localLaundryService = materialIcon(name = "Rounded.LocalLaundryService") {
            materialPath {
                moveTo(9.64f, 16.36f)
                curveToRelative(1.3f, 1.3f, 3.42f, 1.3f, 4.72f, 0.0f)
                curveToRelative(1.3f, -1.3f, 1.3f, -3.42f, 0.0f, -4.72f)
                lineTo(9.64f, 16.36f)
                close()
                moveTo(18.0f, 2.01f)
                lineTo(6.0f, 2.0f)
                curveTo(4.89f, 2.0f, 4.0f, 2.89f, 4.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(20.0f, 2.89f, 19.11f, 2.01f, 18.0f, 2.01f)
                close()
                moveTo(11.0f, 5.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(10.45f, 5.0f, 11.0f, 5.0f)
                close()
                moveTo(8.0f, 5.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(8.55f, 7.0f, 8.0f, 7.0f)
                reflectiveCurveTo(7.0f, 6.55f, 7.0f, 6.0f)
                reflectiveCurveTo(7.45f, 5.0f, 8.0f, 5.0f)
                close()
                moveTo(12.0f, 19.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                curveToRelative(0.0f, -2.76f, 2.24f, -5.0f, 5.0f, -5.0f)
                reflectiveCurveToRelative(5.0f, 2.24f, 5.0f, 5.0f)
                curveTo(17.0f, 16.76f, 14.76f, 19.0f, 12.0f, 19.0f)
                close()
            }
        }
        return _localLaundryService!!
    }

private var _localLaundryService: ImageVector? = null
