/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._30fps: ImageVector
    get() {
        if (__30fps != null) {
            return __30fps!!
        }
        __30fps = materialIcon(name = "Rounded._30fps") {
            materialPath {
                moveTo(2.0f, 6.5f)
                lineTo(2.0f, 6.5f)
                curveTo(2.0f, 7.33f, 2.67f, 8.0f, 3.5f, 8.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(2.5f)
                horizontalLineTo(4.5f)
                curveTo(3.67f, 10.5f, 3.0f, 11.17f, 3.0f, 12.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(16.0f)
                horizontalLineTo(3.5f)
                curveTo(2.67f, 16.0f, 2.0f, 16.67f, 2.0f, 17.5f)
                verticalLineToRelative(0.0f)
                curveTo(2.0f, 18.33f, 2.67f, 19.0f, 3.5f, 19.0f)
                horizontalLineTo(8.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineToRelative(-1.9f)
                curveToRelative(0.0f, -1.16f, -0.94f, -2.1f, -2.1f, -2.1f)
                curveToRelative(1.16f, 0.0f, 2.1f, -0.94f, 2.1f, -2.1f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                horizontalLineTo(3.5f)
                curveTo(2.67f, 5.0f, 2.0f, 5.67f, 2.0f, 6.5f)
                close()
                moveTo(19.0f, 8.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(19.0f)
                moveTo(19.0f, 5.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineTo(8.0f)
                curveTo(22.0f, 6.34f, 20.66f, 5.0f, 19.0f, 5.0f)
                close()
            }
        }
        return __30fps!!
    }

private var __30fps: ImageVector? = null
