/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ScreenLockLandscape: ImageVector
    get() {
        if (_screenLockLandscape != null) {
            return _screenLockLandscape!!
        }
        _screenLockLandscape = materialIcon(name = "Sharp.ScreenLockLandscape") {
            materialPath {
                moveTo(23.0f, 5.0f)
                lineTo(1.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 5.0f)
                close()
                moveTo(19.0f, 17.0f)
                lineTo(5.0f, 17.0f)
                lineTo(5.0f, 7.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(10.0f)
                close()
                moveTo(9.0f, 16.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-0.9f)
                curveToRelative(0.0f, -1.0f, -0.69f, -1.92f, -1.68f, -2.08f)
                curveTo(11.07f, 7.83f, 10.0f, 8.79f, 10.0f, 10.0f)
                verticalLineToRelative(1.0f)
                lineTo(9.0f, 11.0f)
                verticalLineToRelative(5.0f)
                close()
                moveTo(10.8f, 10.0f)
                curveToRelative(0.0f, -0.66f, 0.54f, -1.2f, 1.2f, -1.2f)
                reflectiveCurveToRelative(1.2f, 0.54f, 1.2f, 1.2f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.4f)
                verticalLineToRelative(-1.0f)
                close()
            }
        }
        return _screenLockLandscape!!
    }

private var _screenLockLandscape: ImageVector? = null
