/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BookmarkRemove: ImageVector
    get() {
        if (_bookmarkRemove != null) {
            return _bookmarkRemove!!
        }
        _bookmarkRemove = materialIcon(name = "TwoTone.BookmarkRemove") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.0f, 17.97f)
                lineToRelative(0.0f, -7.07f)
                curveToRelative(-2.28f, -0.46f, -4.0f, -2.48f, -4.0f, -4.9f)
                curveToRelative(0.0f, -0.34f, 0.03f, -0.68f, 0.1f, -1.0f)
                lineTo(7.0f, 5.0f)
                verticalLineToRelative(12.97f)
                lineToRelative(5.0f, -2.14f)
                lineTo(17.0f, 17.97f)
                close()
            }
            materialPath {
                moveTo(21.0f, 7.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(17.0f, 17.97f)
                lineToRelative(-5.0f, -2.14f)
                lineToRelative(-5.0f, 2.14f)
                verticalLineTo(5.0f)
                lineToRelative(6.1f, 0.0f)
                curveToRelative(0.15f, -0.74f, 0.46f, -1.42f, 0.9f, -2.0f)
                lineTo(7.0f, 3.0f)
                curveTo(5.9f, 3.0f, 5.0f, 3.9f, 5.0f, 5.0f)
                verticalLineToRelative(16.0f)
                lineToRelative(7.0f, -3.0f)
                lineToRelative(7.0f, 3.0f)
                lineToRelative(0.0f, -10.1f)
                curveToRelative(-0.32f, 0.07f, -0.66f, 0.1f, -1.0f, 0.1f)
                curveToRelative(-0.34f, 0.0f, -0.68f, -0.03f, -1.0f, -0.1f)
                lineTo(17.0f, 17.97f)
                close()
            }
        }
        return _bookmarkRemove!!
    }

private var _bookmarkRemove: ImageVector? = null
