/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.VideoSettings: ImageVector
    get() {
        if (_videoSettings != null) {
            return _videoSettings!!
        }
        _videoSettings = materialIcon(name = "Outlined.VideoSettings") {
            materialPath {
                moveTo(3.0f, 6.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(3.0f)
                curveTo(1.9f, 4.0f, 1.0f, 4.9f, 1.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(6.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 12.0f)
                lineToRelative(-6.0f, -4.0f)
                lineToRelative(0.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(22.71f, 18.43f)
                curveToRelative(0.03f, -0.29f, 0.04f, -0.58f, 0.01f, -0.86f)
                lineToRelative(1.07f, -0.85f)
                curveToRelative(0.1f, -0.08f, 0.12f, -0.21f, 0.06f, -0.32f)
                lineToRelative(-1.03f, -1.79f)
                curveToRelative(-0.06f, -0.11f, -0.19f, -0.15f, -0.31f, -0.11f)
                lineTo(21.23f, 15.0f)
                curveToRelative(-0.23f, -0.17f, -0.48f, -0.31f, -0.75f, -0.42f)
                lineToRelative(-0.2f, -1.36f)
                curveTo(20.26f, 13.09f, 20.16f, 13.0f, 20.03f, 13.0f)
                horizontalLineToRelative(-2.07f)
                curveToRelative(-0.12f, 0.0f, -0.23f, 0.09f, -0.25f, 0.21f)
                lineToRelative(-0.2f, 1.36f)
                curveToRelative(-0.26f, 0.11f, -0.51f, 0.26f, -0.74f, 0.42f)
                lineToRelative(-1.28f, -0.5f)
                curveToRelative(-0.12f, -0.05f, -0.25f, 0.0f, -0.31f, 0.11f)
                lineToRelative(-1.03f, 1.79f)
                curveToRelative(-0.06f, 0.11f, -0.04f, 0.24f, 0.06f, 0.32f)
                lineToRelative(1.07f, 0.86f)
                curveToRelative(-0.03f, 0.29f, -0.04f, 0.58f, -0.01f, 0.86f)
                lineToRelative(-1.07f, 0.85f)
                curveToRelative(-0.1f, 0.08f, -0.12f, 0.21f, -0.06f, 0.32f)
                lineToRelative(1.03f, 1.79f)
                curveToRelative(0.06f, 0.11f, 0.19f, 0.15f, 0.31f, 0.11f)
                lineToRelative(1.27f, -0.5f)
                curveToRelative(0.23f, 0.17f, 0.48f, 0.31f, 0.75f, 0.42f)
                lineToRelative(0.2f, 1.36f)
                curveToRelative(0.02f, 0.12f, 0.12f, 0.21f, 0.25f, 0.21f)
                horizontalLineToRelative(2.07f)
                curveToRelative(0.12f, 0.0f, 0.23f, -0.09f, 0.25f, -0.21f)
                lineToRelative(0.2f, -1.36f)
                curveToRelative(0.26f, -0.11f, 0.51f, -0.26f, 0.74f, -0.42f)
                lineToRelative(1.28f, 0.5f)
                curveToRelative(0.12f, 0.05f, 0.25f, 0.0f, 0.31f, -0.11f)
                lineToRelative(1.03f, -1.79f)
                curveToRelative(0.06f, -0.11f, 0.04f, -0.24f, -0.06f, -0.32f)
                lineTo(22.71f, 18.43f)
                close()
                moveTo(19.0f, 19.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(19.83f, 19.5f, 19.0f, 19.5f)
                close()
            }
        }
        return _videoSettings!!
    }

private var _videoSettings: ImageVector? = null
