/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AutoStories: ImageVector
    get() {
        if (_autoStories != null) {
            return _autoStories!!
        }
        _autoStories = materialIcon(name = "Sharp.AutoStories") {
            materialPath {
                moveTo(21.0f, 4.6f)
                verticalLineToRelative(2.12f)
                verticalLineToRelative(7.24f)
                verticalLineToRelative(2.66f)
                curveTo(19.86f, 16.21f, 18.69f, 16.0f, 17.5f, 16.0f)
                curveToRelative(-1.9f, 0.0f, -3.78f, 0.54f, -5.5f, 1.58f)
                verticalLineToRelative(-3.62f)
                verticalLineTo(7.79f)
                verticalLineTo(5.48f)
                curveTo(10.38f, 4.55f, 8.51f, 4.0f, 6.5f, 4.0f)
                reflectiveCurveTo(2.62f, 4.55f, 1.0f, 5.48f)
                verticalLineTo(20.0f)
                curveToRelative(1.52f, -1.18f, 3.43f, -2.0f, 5.5f, -2.0f)
                reflectiveCurveToRelative(3.98f, 0.82f, 5.5f, 2.0f)
                curveToRelative(1.52f, -1.18f, 3.43f, -2.0f, 5.5f, -2.0f)
                reflectiveCurveToRelative(3.98f, 0.82f, 5.5f, 2.0f)
                verticalLineTo(5.48f)
                curveTo(22.37f, 5.12f, 21.7f, 4.84f, 21.0f, 4.6f)
                close()
            }
            materialPath {
                moveTo(19.0f, 0.5f)
                lineToRelative(-5.0f, 5.0f)
                lineToRelative(0.0f, 9.5f)
                lineToRelative(5.0f, -4.5f)
                close()
            }
        }
        return _autoStories!!
    }

private var _autoStories: ImageVector? = null
