/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ReportOff: ImageVector
    get() {
        if (_reportOff != null) {
            return _reportOff!!
        }
        _reportOff = materialIcon(name = "Sharp.ReportOff") {
            materialPath {
                moveTo(11.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.33f)
                lineToRelative(7.2f, 7.2f)
                lineToRelative(0.8f, -0.8f)
                lineTo(21.0f, 8.27f)
                lineTo(15.73f, 3.0f)
                lineTo(8.27f, 3.0f)
                lineToRelative(-0.8f, 0.8f)
                lineTo(11.0f, 7.33f)
                close()
                moveTo(2.41f, 1.58f)
                lineTo(1.0f, 2.99f)
                lineToRelative(3.64f, 3.64f)
                lineTo(3.0f, 8.27f)
                verticalLineToRelative(7.46f)
                lineTo(8.27f, 21.0f)
                horizontalLineToRelative(7.46f)
                lineToRelative(1.64f, -1.64f)
                lineTo(21.01f, 23.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.41f, 1.58f)
                close()
                moveTo(11.0f, 12.99f)
                lineToRelative(0.01f, 0.01f)
                lineTo(11.0f, 13.0f)
                verticalLineToRelative(-0.01f)
                close()
                moveTo(12.0f, 17.3f)
                curveToRelative(-0.72f, 0.0f, -1.3f, -0.58f, -1.3f, -1.3f)
                curveToRelative(0.0f, -0.72f, 0.58f, -1.3f, 1.3f, -1.3f)
                reflectiveCurveToRelative(1.3f, 0.58f, 1.3f, 1.3f)
                curveToRelative(0.0f, 0.72f, -0.58f, 1.3f, -1.3f, 1.3f)
                close()
            }
        }
        return _reportOff!!
    }

private var _reportOff: ImageVector? = null
