/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideoStable: ImageVector
    get() {
        if (_videoStable != null) {
            return _videoStable!!
        }
        _videoStable = materialIcon(name = "Sharp.VideoStable") {
            materialPath {
                moveTo(2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(2.0f)
                close()
                moveTo(4.0f, 18.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(2.95f)
                lineToRelative(-2.33f, 8.73f)
                lineTo(16.82f, 18.0f)
                horizontalLineTo(4.0f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineToRelative(-2.95f)
                lineToRelative(2.34f, -8.73f)
                lineTo(7.18f, 6.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(18.0f)
                close()
            }
        }
        return _videoStable!!
    }

private var _videoStable: ImageVector? = null
