/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.SnapshotMutableStateImpl;
import androidx.compose.runtime.SnapshotMutationPolicy;
import androidx.compose.runtime.SnapshotStateKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\u000fB\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/runtime/ParcelableSnapshotMutableState;", "T", "Landroidx/compose/runtime/SnapshotMutableStateImpl;", "Landroid/os/Parcelable;", "value", "policy", "Landroidx/compose/runtime/SnapshotMutationPolicy;", "(Ljava/lang/Object;Landroidx/compose/runtime/SnapshotMutationPolicy;)V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "runtime_release"})
@SuppressLint(value={"BanParcelableUsage"})
public final class ParcelableSnapshotMutableState<T>
extends SnapshotMutableStateImpl<T>
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int PolicyNeverEquals = 0;
    private static final int PolicyStructuralEquality = 1;
    private static final int PolicyReferentialEquality = 2;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<ParcelableSnapshotMutableState<Object>> CREATOR = (Parcelable.Creator)new Parcelable.ClassLoaderCreator<ParcelableSnapshotMutableState<Object>>(){

        @NotNull
        public ParcelableSnapshotMutableState<Object> createFromParcel(@NotNull Parcel parcel, @Nullable ClassLoader loader) {
            SnapshotMutationPolicy<T> snapshotMutationPolicy;
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Object value = parcel.readValue(classLoader);
            int policyIndex = parcel.readInt();
            switch (policyIndex) {
                case 0: {
                    snapshotMutationPolicy = SnapshotStateKt.neverEqualPolicy();
                    break;
                }
                case 1: {
                    snapshotMutationPolicy = SnapshotStateKt.structuralEqualityPolicy();
                    break;
                }
                case 2: {
                    snapshotMutationPolicy = SnapshotStateKt.referentialEqualityPolicy();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported MutableState policy " + policyIndex + " was restored");
                }
            }
            return new ParcelableSnapshotMutableState<Object>(value, snapshotMutationPolicy);
        }

        @NotNull
        public ParcelableSnapshotMutableState<Object> createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return this.createFromParcel(parcel, null);
        }

        @NotNull
        public ParcelableSnapshotMutableState<Object>[] newArray(int size) {
            return new ParcelableSnapshotMutableState[size];
        }
    };

    public ParcelableSnapshotMutableState(T value, @NotNull SnapshotMutationPolicy<T> policy) {
        Intrinsics.checkNotNullParameter(policy, (String)"policy");
        super(value, policy);
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        int n;
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeValue(this.getValue());
        SnapshotMutationPolicy snapshotMutationPolicy = this.getPolicy();
        if (Intrinsics.areEqual(snapshotMutationPolicy, SnapshotStateKt.neverEqualPolicy())) {
            n = 0;
        } else if (Intrinsics.areEqual(snapshotMutationPolicy, SnapshotStateKt.structuralEqualityPolicy())) {
            n = 1;
        } else if (Intrinsics.areEqual(snapshotMutationPolicy, SnapshotStateKt.referentialEqualityPolicy())) {
            n = 2;
        } else {
            throw new IllegalStateException("Only known types of MutableState's SnapshotMutationPolicy are supported");
        }
        parcel.writeInt(n);
    }

    public int describeContents() {
        return 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/compose/runtime/ParcelableSnapshotMutableState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Landroidx/compose/runtime/ParcelableSnapshotMutableState;", "getCREATOR$annotations", "PolicyNeverEquals", "", "PolicyReferentialEquality", "PolicyStructuralEquality", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getCREATOR$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

