/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.IntStack;
import androidx.compose.runtime.PrioritySet;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b9\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00a6\u00012\u00020\u0001:\u0002\u00a6\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\u000e\u00106\u001a\u0002032\u0006\u00105\u001a\u00020\nJ\u0010\u00107\u001a\u00020\u00072\b\b\u0002\u00108\u001a\u00020\nJ\u000e\u00109\u001a\u00020\n2\u0006\u00107\u001a\u00020\u0007J\r\u0010:\u001a\u000203H\u0000\u00a2\u0006\u0002\b;J\u0006\u0010<\u001a\u000203J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\nH\u0002J\b\u0010?\u001a\u000203H\u0002J\u0006\u0010@\u001a\u000203J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\nH\u0002J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\nH\u0002J \u0010C\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010E\u001a\u00020\n2\u0006\u00108\u001a\u00020\nH\u0002J\u0010\u0010F\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002J(\u0010G\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u0010H\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010I\u001a\u00020\nJ\u0006\u0010J\u001a\u000203J\u000e\u0010K\u001a\u0002032\u0006\u00107\u001a\u00020\u0007J\u000e\u0010K\u001a\u0002032\u0006\u00108\u001a\u00020\nJ \u0010L\u001a\u0002032\u0006\u0010#\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\u0006\u0010M\u001a\u00020\nH\u0002JK\u0010N\u001a\u0002032\u0006\u0010>\u001a\u00020\n28\u0010O\u001a4\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bQ\u0012\b\bR\u0012\u0004\b\b(8\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\bQ\u0012\b\bR\u0012\u0004\b\b(S\u0012\u0004\u0012\u0002030PH\u0086\bJ\u0010\u0010T\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\nJ\u0010\u0010U\u001a\u00020\n2\u0006\u00108\u001a\u00020\nH\u0002J\u000e\u0010V\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u0010\u0010W\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\nJ\u000e\u0010X\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u000e\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010ZJ\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\nJ\u0016\u0010^\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\n2\u0006\u0010>\u001a\u00020\nJ\u000e\u0010_\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\nJ\u0010\u0010`\u001a\u0002032\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u0010\u0010b\u001a\u0002032\u0006\u0010'\u001a\u00020\nH\u0002J\u000e\u0010c\u001a\u0002032\u0006\u0010d\u001a\u00020\nJ\u0018\u0010e\u001a\u0002032\u0006\u0010'\u001a\u00020\n2\u0006\u0010>\u001a\u00020\nH\u0002J\u000e\u0010 \u001a\u00020\u000e2\u0006\u00108\u001a\u00020\nJ\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020\n0gH\u0002J\u0010\u0010h\u001a\u0002032\b\b\u0002\u0010>\u001a\u00020\nJ \u0010i\u001a\u0002032\u0006\u0010j\u001a\u00020\n2\u0006\u0010k\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002J&\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00070g2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u00020\n2\b\b\u0002\u0010m\u001a\u00020\u000eJ\u000e\u0010n\u001a\u0002032\u0006\u0010o\u001a\u00020\nJ\u0010\u0010p\u001a\u0002032\u0006\u00108\u001a\u00020\nH\u0002J$\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00070g2\u0006\u0010o\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u00020\nJ\u0018\u0010r\u001a\u0002032\u0006\u00108\u001a\u00020\n2\u0006\u0010>\u001a\u00020\nH\u0002J$\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00070g2\u0006\u00107\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\n2\u0006\u0010t\u001a\u00020\u0000J\u0010\u0010u\u001a\u0004\u0018\u00010\u00012\u0006\u00107\u001a\u00020\u0007J\u0010\u0010u\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\n2\u0006\u00107\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u0010\u0010v\u001a\u00020\n2\u0006\u00108\u001a\u00020\nH\u0002J\u0018\u0010w\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u0010H\u001a\u00020\nH\u0002J\b\u0010x\u001a\u000203H\u0002J\u0018\u0010y\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002J\u0006\u0010z\u001a\u00020\u000eJ\u0018\u0010{\u001a\u00020\u000e2\u0006\u0010|\u001a\u00020\n2\u0006\u0010}\u001a\u00020\nH\u0002J \u0010~\u001a\u0002032\u0006\u0010|\u001a\u00020\n2\u0006\u0010}\u001a\u00020\n2\u0006\u0010>\u001a\u00020\nH\u0002J\u0006\u0010\u007f\u001a\u000203J\t\u0010\u0080\u0001\u001a\u00020\nH\u0002J\t\u0010\u0081\u0001\u001a\u000203H\u0002J\u000f\u0010\u0082\u0001\u001a\u0002032\u0006\u00107\u001a\u00020\u0007J\u0011\u0010\u0083\u0001\u001a\u0002032\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\n2\b\u0010a\u001a\u0004\u0018\u00010\u0001J#\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010>\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\b\u0010a\u001a\u0004\u0018\u00010\u0001J\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0001J\u0007\u0010\u0085\u0001\u001a\u00020\nJ\u0007\u0010\u0086\u0001\u001a\u000203J\u0019\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\nJ\u001a\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00012\u0007\u0010\u0088\u0001\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u001a\u0010\u0089\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0001J%\u0010\u0089\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0001J\u0007\u0010\u008c\u0001\u001a\u000203J\u000f\u0010\u008c\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\nJ\u001a\u0010\u008c\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0001J/\u0010\u008c\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u000e2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010\u008e\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0001J$\u0010\u008e\u0001\u001a\u0002032\u0006\u0010d\u001a\u00020\n2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010u\u001a\u0004\u0018\u00010\u0001J\t\u0010\u008f\u0001\u001a\u00020\\H\u0016J\u0013\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0091\u0001\u001a\u0002032\u0007\u0010\u0092\u0001\u001a\u00020\n2\u0007\u0010\u0093\u0001\u001a\u00020\nH\u0002J\u0011\u0010\u0094\u0001\u001a\u0002032\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u0011\u0010\u0095\u0001\u001a\u0002032\u0006\u0010>\u001a\u00020\nH\u0002J\u001a\u0010\u0096\u0001\u001a\u0002032\u0006\u0010>\u001a\u00020\n2\u0007\u0010\u0083\u0001\u001a\u00020&H\u0002J\u0019\u0010\u0097\u0001\u001a\u0002032\u0006\u00107\u001a\u00020\u00072\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u0011\u0010\u0097\u0001\u001a\u0002032\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0098\u0001\u001a\u0002032\u0006\u00108\u001a\u00020\n2\b\u0010a\u001a\u0004\u0018\u00010\u0001H\u0002J\u0011\u0010\u0099\u0001\u001a\u0002032\b\u0010a\u001a\u0004\u0018\u00010\u0001J\u000f\u0010\u009a\u0001\u001a\u000203H\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u000f\u0010\u009c\u0001\u001a\u000203H\u0000\u00a2\u0006\u0003\b\u009d\u0001J\u0015\u0010\u009e\u0001\u001a\u00020\n*\u00020\u001d2\u0006\u00104\u001a\u00020\nH\u0002J\u0014\u0010E\u001a\u00020\n*\u00020\u001d2\u0006\u00104\u001a\u00020\nH\u0002J\u0013\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020\n0g*\u00020\u001dH\u0002J\u001b\u0010\u00a0\u0001\u001a\u000203*\b0\u00a1\u0001j\u0003`\u00a2\u00012\u0006\u00108\u001a\u00020\nH\u0002J\u0015\u0010\u00a3\u0001\u001a\u00020\n*\u00020\u001d2\u0006\u00104\u001a\u00020\nH\u0002J\u0014\u0010#\u001a\u00020\n*\u00020\u001d2\u0006\u00108\u001a\u00020\nH\u0002J\u0015\u0010\u00a4\u0001\u001a\u00020\n*\u00020\u001d2\u0006\u00104\u001a\u00020\nH\u0002J\u001d\u0010\u00a5\u0001\u001a\u000203*\u00020\u001d2\u0006\u00104\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\fR\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0018\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010*X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006\u00a7\u0001"}, d2={"Landroidx/compose/runtime/SlotWriter;", "", "table", "Landroidx/compose/runtime/SlotTable;", "(Landroidx/compose/runtime/SlotTable;)V", "anchors", "Ljava/util/ArrayList;", "Landroidx/compose/runtime/Anchor;", "Lkotlin/collections/ArrayList;", "capacity", "", "getCapacity", "()I", "<set-?>", "", "closed", "getClosed", "()Z", "currentGroup", "getCurrentGroup", "currentGroupEnd", "getCurrentGroupEnd", "currentSlot", "currentSlotEnd", "endStack", "Landroidx/compose/runtime/IntStack;", "groupGapLen", "groupGapStart", "groups", "", "insertCount", "isGroupEnd", "isNode", "nodeCount", "nodeCountStack", "parent", "getParent", "pendingRecalculateMarks", "Landroidx/compose/runtime/PrioritySet;", "size", "getSize$runtime_release", "slots", "", "[Ljava/lang/Object;", "slotsGapLen", "slotsGapOwner", "slotsGapStart", "startStack", "getTable$runtime_release", "()Landroidx/compose/runtime/SlotTable;", "addToGroupSizeAlongSpine", "", "address", "amount", "advanceBy", "anchor", "index", "anchorIndex", "bashGroup", "bashGroup$runtime_release", "beginInsert", "childContainsAnyMarks", "group", "clearSlotGap", "close", "containsAnyGroupMarks", "containsGroupMark", "dataAnchorToDataIndex", "gapLen", "dataIndex", "dataIndexToDataAddress", "dataIndexToDataAnchor", "gapStart", "endGroup", "endInsert", "ensureStarted", "fixParentAnchorsFor", "firstChild", "forEachData", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "data", "groupAux", "groupIndexToAddress", "groupKey", "groupObjectKey", "groupSize", "groupSlots", "", "groupsAsString", "", "indexInCurrentGroup", "indexInGroup", "indexInParent", "insertAux", "value", "insertGroups", "insertParentGroup", "key", "insertSlots", "keys", "", "markGroup", "moveAnchors", "originalLocation", "newLocation", "moveFrom", "removeSourceGroup", "moveGroup", "offset", "moveGroupGapTo", "moveIntoGroupFrom", "moveSlotGapTo", "moveTo", "writer", "node", "parentAnchorToIndex", "parentIndexToAnchor", "recalculateMarks", "removeAnchors", "removeGroup", "removeGroups", "start", "len", "removeSlots", "reset", "restoreCurrentGroupEnd", "saveCurrentGroupEnd", "seek", "set", "skip", "skipGroup", "skipToGroupEnd", "slot", "groupIndex", "startData", "aux", "objectKey", "startGroup", "dataKey", "startNode", "toString", "update", "updateAnchors", "previousGapStart", "newGapStart", "updateAux", "updateContainsMark", "updateContainsMarkNow", "updateNode", "updateNodeOfGroup", "updateParentNode", "verifyDataAnchors", "verifyDataAnchors$runtime_release", "verifyParentAnchors", "verifyParentAnchors$runtime_release", "auxIndex", "dataIndexes", "groupAsString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodeIndex", "slotIndex", "updateDataIndex", "Companion", "runtime_release"})
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 5 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 6 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,3481:1\n4105#2,5:3482\n4105#2,5:3487\n4105#2,5:3492\n4105#2,5:3497\n4105#2,5:3503\n4105#2,5:3508\n4105#2,5:3513\n4105#2,5:3518\n4105#2,5:3523\n4105#2,5:3528\n4105#2,5:3533\n4105#2,5:3538\n4105#2,5:3543\n4105#2,5:3548\n4105#2,5:3553\n4105#2,5:3558\n4105#2,5:3563\n4105#2,5:3568\n4105#2,5:3581\n4105#2,5:3600\n4105#2,5:3605\n4105#2,5:3610\n1#3:3502\n162#4,8:3573\n162#4,8:3586\n3359#5,6:3594\n33#6,6:3615\n82#6,3:3621\n33#6,4:3624\n85#6,2:3628\n38#6:3630\n87#6:3631\n231#6,3:3632\n64#6,4:3635\n234#6,2:3639\n69#6:3641\n236#6:3642\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n*L\n1353#1:3482,5\n1377#1:3487,5\n1390#1:3492,5\n1393#1:3497,5\n1433#1:3503,5\n1454#1:3508,5\n1501#1:3513,5\n1506#1:3518,5\n1546#1:3523,5\n1557#1:3528,5\n1684#1:3533,5\n1760#1:3538,5\n1765#1:3543,5\n1797#1:3548,5\n1850#1:3553,5\n1851#1:3558,5\n1864#1:3563,5\n1958#1:3568,5\n2243#1:3581,5\n2530#1:3600,5\n2542#1:3605,5\n2739#1:3610,5\n2225#1:3573,8\n2315#1:3586,8\n2335#1:3594,6\n2835#1:3615,6\n3005#1:3621,3\n3005#1:3624,4\n3005#1:3628,2\n3005#1:3630\n3005#1:3631\n3008#1:3632,3\n3008#1:3635,4\n3008#1:3639,2\n3008#1:3641\n3008#1:3642\n*E\n"})
public final class SlotWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SlotTable table;
    @NotNull
    private int[] groups;
    @NotNull
    private Object[] slots;
    @NotNull
    private ArrayList<Anchor> anchors;
    private int groupGapStart;
    private int groupGapLen;
    private int currentSlot;
    private int currentSlotEnd;
    private int slotsGapStart;
    private int slotsGapLen;
    private int slotsGapOwner;
    private int insertCount;
    private int nodeCount;
    @NotNull
    private final IntStack startStack;
    @NotNull
    private final IntStack endStack;
    @NotNull
    private final IntStack nodeCountStack;
    private int currentGroup;
    private int currentGroupEnd;
    private int parent;
    private boolean closed;
    @Nullable
    private PrioritySet pendingRecalculateMarks;

    public SlotWriter(@NotNull SlotTable table) {
        this.table = table;
        this.groups = this.table.getGroups();
        this.slots = this.table.getSlots();
        this.anchors = this.table.getAnchors$runtime_release();
        this.groupGapStart = this.table.getGroupsSize();
        this.groupGapLen = this.groups.length / 5 - this.table.getGroupsSize();
        this.slotsGapStart = this.table.getSlotsSize();
        this.slotsGapLen = this.slots.length - this.table.getSlotsSize();
        this.slotsGapOwner = this.table.getGroupsSize();
        this.startStack = new IntStack();
        this.endStack = new IntStack();
        this.nodeCountStack = new IntStack();
        this.currentGroupEnd = this.table.getGroupsSize();
        this.parent = -1;
    }

    @NotNull
    public final SlotTable getTable$runtime_release() {
        return this.table;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentGroupEnd() {
        return this.currentGroupEnd;
    }

    public final boolean isGroupEnd() {
        return this.currentGroup == this.currentGroupEnd;
    }

    public final boolean isNode() {
        return this.currentGroup < this.currentGroupEnd && SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(this.currentGroup));
    }

    public final boolean isNode(int index) {
        return SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(index));
    }

    public final int nodeCount(int index) {
        return SlotTableKt.access$nodeCount(this.groups, this.groupIndexToAddress(index));
    }

    public final int groupKey(int index) {
        return SlotTableKt.access$key(this.groups, this.groupIndexToAddress(index));
    }

    @Nullable
    public final Object groupObjectKey(int index) {
        int address = this.groupIndexToAddress(index);
        return SlotTableKt.access$hasObjectKey(this.groups, address) ? this.slots[SlotTableKt.access$objectKeyIndex(this.groups, address)] : null;
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(index));
    }

    @Nullable
    public final Object groupAux(int index) {
        int address = this.groupIndexToAddress(index);
        return SlotTableKt.access$hasAux(this.groups, address) ? this.slots[this.auxIndex(this.groups, address)] : Composer.Companion.getEmpty();
    }

    public final boolean indexInParent(int index) {
        return index > this.parent && index < this.currentGroupEnd || this.parent == 0 && index == 0;
    }

    public final boolean indexInCurrentGroup(int index) {
        return this.indexInGroup(index, this.currentGroup);
    }

    public final boolean indexInGroup(int index, int group) {
        int n;
        if (group == this.parent) {
            n = this.currentGroupEnd;
        } else if (group > this.startStack.peekOr(0)) {
            n = group + this.groupSize(group);
        } else {
            int openIndex = this.startStack.indexOf(group);
            n = openIndex < 0 ? group + this.groupSize(group) : this.getCapacity() - this.groupGapLen - this.endStack.peek(openIndex);
        }
        int end2 = n;
        return index > group && index < end2;
    }

    @Nullable
    public final Object node(int index) {
        int address = this.groupIndexToAddress(index);
        return SlotTableKt.access$isNode(this.groups, address) ? this.slots[this.dataIndexToDataAddress(this.nodeIndex(this.groups, address))] : null;
    }

    @Nullable
    public final Object node(@NotNull Anchor anchor) {
        return this.node(anchor.toIndexFor(this));
    }

    public final int getParent() {
        return this.parent;
    }

    public final int parent(int index) {
        return this.parent(this.groups, index);
    }

    public final int parent(@NotNull Anchor anchor) {
        return anchor.getValid() ? this.parent(this.groups, this.anchorIndex(anchor)) : -1;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void close() {
        this.closed = true;
        if (this.startStack.isEmpty()) {
            this.moveGroupGapTo(this.getSize$runtime_release());
            this.moveSlotGapTo(this.slots.length - this.slotsGapLen, this.groupGapStart);
            this.clearSlotGap();
            this.recalculateMarks();
        }
        this.table.close$runtime_release(this, this.groups, this.groupGapStart, this.slots, this.slotsGapStart, this.anchors);
    }

    public final void reset() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot reset when inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.recalculateMarks();
        this.currentGroup = 0;
        this.currentGroupEnd = this.getCapacity() - this.groupGapLen;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
        this.nodeCount = 0;
    }

    @Nullable
    public final Object update(@Nullable Object value) {
        Object result2 = this.skip();
        this.set(value);
        return result2;
    }

    public final void updateAux(@Nullable Object value) {
        int address = this.groupIndexToAddress(this.currentGroup);
        boolean value$iv = SlotTableKt.access$hasAux(this.groups, address);
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Updating the data of a group that was not created with a data slot";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)this.auxIndex((int[])this.groups, (int)address))] = value;
    }

    public final void insertAux(@Nullable Object value) {
        boolean value$iv = this.insertCount >= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot insert auxiliary data when not inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int parent = this.parent;
        int parentGroupAddress = this.groupIndexToAddress(parent);
        boolean value$iv2 = !SlotTableKt.access$hasAux(this.groups, parentGroupAddress);
        boolean $i$f$runtimeCheck2 = false;
        if (!value$iv2) {
            boolean bl = false;
            String message$iv = "Group already has auxiliary data";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.insertSlots(1, parent);
        int auxIndex = this.auxIndex(this.groups, parentGroupAddress);
        int auxAddress = this.dataIndexToDataAddress(auxIndex);
        if (this.currentSlot > auxIndex) {
            int slotsToMove = this.currentSlot - auxIndex;
            if (!(slotsToMove < 3)) {
                boolean bl = false;
                String string = "Moving more than two slot not supported";
                throw new IllegalStateException(string.toString());
            }
            if (slotsToMove > 1) {
                this.slots[auxAddress + 2] = this.slots[auxAddress + 1];
            }
            this.slots[auxAddress + 1] = this.slots[auxAddress];
        }
        SlotTableKt.access$addAux(this.groups, parentGroupAddress);
        this.slots[auxAddress] = value;
        int n = this.currentSlot;
        this.currentSlot = n + 1;
    }

    public final void updateNode(@Nullable Object value) {
        this.updateNodeOfGroup(this.currentGroup, value);
    }

    public final void updateNode(@NotNull Anchor anchor, @Nullable Object value) {
        this.updateNodeOfGroup(anchor.toIndexFor(this), value);
    }

    public final void updateParentNode(@Nullable Object value) {
        this.updateNodeOfGroup(this.parent, value);
    }

    public final void set(@Nullable Object value) {
        boolean value$iv = this.currentSlot <= this.currentSlotEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Writing to an invalid slot";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)(this.currentSlot - 1))] = value;
    }

    @Nullable
    public final Object set(int index, @Nullable Object value) {
        return this.set(this.currentGroup, index, value);
    }

    @Nullable
    public final Object set(int group, int index, @Nullable Object value) {
        int address = this.groupIndexToAddress(group);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(group + 1));
        int slotsIndex = slotsStart + index;
        boolean value$iv = slotsIndex >= slotsStart && slotsIndex < slotsEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Write to an invalid slot index " + index + " for group " + group;
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int slotAddress = this.dataIndexToDataAddress(slotsIndex);
        Object result2 = this.slots[slotAddress];
        this.slots[slotAddress] = value;
        return result2;
    }

    @Nullable
    public final Object skip() {
        if (this.insertCount > 0) {
            this.insertSlots(1, this.parent);
        }
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[this.dataIndexToDataAddress(n)];
    }

    @Nullable
    public final Object slot(@NotNull Anchor anchor, int index) {
        return this.slot(this.anchorIndex(anchor), index);
    }

    @Nullable
    public final Object slot(int groupIndex, int index) {
        int address = this.groupIndexToAddress(groupIndex);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(groupIndex + 1));
        int slotsIndex = slotsStart + index;
        if (!(slotsStart <= slotsIndex ? slotsIndex < slotsEnd : false)) {
            return Composer.Companion.getEmpty();
        }
        int slotAddress = this.dataIndexToDataAddress(slotsIndex);
        return this.slots[slotAddress];
    }

    public final void advanceBy(int amount) {
        int newSlot;
        boolean value$iv = amount >= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot seek backwards";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (!(this.insertCount <= 0)) {
            boolean $i$a$-check-SlotWriter$advanceBy$32 = false;
            String $i$a$-check-SlotWriter$advanceBy$32 = "Cannot call seek() while inserting";
            throw new IllegalStateException($i$a$-check-SlotWriter$advanceBy$32.toString());
        }
        if (amount == 0) {
            return;
        }
        int index = this.currentGroup + amount;
        boolean value$iv2 = index >= this.parent && index <= this.currentGroupEnd;
        boolean $i$f$runtimeCheck2 = false;
        if (!value$iv2) {
            boolean bl = false;
            String message$iv = "Cannot seek outside the current group (" + this.parent + '-' + this.currentGroupEnd + ')';
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.currentGroup = index;
        this.currentSlot = newSlot = this.dataIndex(this.groups, this.groupIndexToAddress(index));
        this.currentSlotEnd = newSlot;
    }

    public final void seek(@NotNull Anchor anchor) {
        this.advanceBy(anchor.toIndexFor(this) - this.currentGroup);
    }

    public final void skipToGroupEnd() {
        int newGroup;
        this.currentGroup = newGroup = this.currentGroupEnd;
        this.currentSlot = this.dataIndex(this.groups, this.groupIndexToAddress(newGroup));
    }

    public final void beginInsert() {
        int n = this.insertCount;
        this.insertCount = n + 1;
        if (n == 0) {
            this.saveCurrentGroupEnd();
        }
    }

    public final void endInsert() {
        if (!(this.insertCount > 0)) {
            boolean $i$a$-check-SlotWriter$endInsert$22 = false;
            String $i$a$-check-SlotWriter$endInsert$22 = "Unbalanced begin/end insert";
            throw new IllegalStateException($i$a$-check-SlotWriter$endInsert$22.toString());
        }
        this.insertCount += -1;
        if (this.insertCount == 0) {
            boolean value$iv = this.nodeCountStack.getSize() == this.startStack.getSize();
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "startGroup/endGroup mismatch while inserting";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            this.restoreCurrentGroupEnd();
        }
    }

    public final void startGroup() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Key must be supplied when inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.startGroup(0, Composer.Companion.getEmpty(), false, Composer.Companion.getEmpty());
    }

    public final void startGroup(int key) {
        this.startGroup(key, Composer.Companion.getEmpty(), false, Composer.Companion.getEmpty());
    }

    public final void startGroup(int key, @Nullable Object dataKey) {
        this.startGroup(key, dataKey, false, Composer.Companion.getEmpty());
    }

    public final void startNode(int key, @Nullable Object objectKey) {
        this.startGroup(key, objectKey, true, Composer.Companion.getEmpty());
    }

    public final void startNode(int key, @Nullable Object objectKey, @Nullable Object node) {
        this.startGroup(key, objectKey, true, node);
    }

    public final void startData(int key, @Nullable Object objectKey, @Nullable Object aux) {
        this.startGroup(key, objectKey, false, aux);
    }

    public final void startData(int key, @Nullable Object aux) {
        this.startGroup(key, Composer.Companion.getEmpty(), false, aux);
    }

    private final void startGroup(int key, Object objectKey, boolean isNode, Object aux) {
        int n;
        boolean inserting = this.insertCount > 0;
        this.nodeCountStack.push(this.nodeCount);
        if (inserting) {
            this.insertGroups(1);
            int current = this.currentGroup;
            int currentAddress = this.groupIndexToAddress(current);
            boolean hasObjectKey = objectKey != Composer.Companion.getEmpty();
            boolean hasAux = !isNode && aux != Composer.Companion.getEmpty();
            SlotTableKt.access$initGroup(this.groups, currentAddress, key, isNode, hasObjectKey, hasAux, this.parent, this.currentSlot);
            this.currentSlotEnd = this.currentSlot;
            int dataSlotsNeeded = (isNode ? 1 : 0) + (hasObjectKey ? 1 : 0) + (hasAux ? 1 : 0);
            if (dataSlotsNeeded > 0) {
                this.insertSlots(dataSlotsNeeded, current);
                Object[] slots = this.slots;
                int currentSlot = this.currentSlot;
                if (isNode) {
                    slots[currentSlot++] = aux;
                }
                if (hasObjectKey) {
                    slots[currentSlot++] = objectKey;
                }
                if (hasAux) {
                    slots[currentSlot++] = aux;
                }
                this.currentSlot = currentSlot;
            }
            this.nodeCount = 0;
            int newCurrent = current + 1;
            this.parent = current;
            this.currentGroup = newCurrent;
            n = newCurrent;
        } else {
            int previousParent = this.parent;
            this.startStack.push(previousParent);
            this.saveCurrentGroupEnd();
            int currentGroup = this.currentGroup;
            int currentGroupAddress = this.groupIndexToAddress(currentGroup);
            if (!Intrinsics.areEqual((Object)aux, (Object)Composer.Companion.getEmpty())) {
                if (isNode) {
                    this.updateNode(aux);
                } else {
                    this.updateAux(aux);
                }
            }
            this.currentSlot = this.slotIndex(this.groups, currentGroupAddress);
            this.currentSlotEnd = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup + 1));
            this.nodeCount = SlotTableKt.access$nodeCount(this.groups, currentGroupAddress);
            this.parent = currentGroup;
            this.currentGroup = currentGroup + 1;
            n = currentGroup + SlotTableKt.access$groupSize(this.groups, currentGroupAddress);
        }
        this.currentGroupEnd = n;
    }

    public final int endGroup() {
        boolean inserting = this.insertCount > 0;
        int currentGroup = this.currentGroup;
        int currentGroupEnd = this.currentGroupEnd;
        int groupIndex = this.parent;
        int groupAddress = this.groupIndexToAddress(groupIndex);
        int newNodes = this.nodeCount;
        int newGroupSize = currentGroup - groupIndex;
        boolean isNode = SlotTableKt.access$isNode(this.groups, groupAddress);
        if (inserting) {
            SlotTableKt.access$updateGroupSize(this.groups, groupAddress, newGroupSize);
            SlotTableKt.access$updateNodeCount(this.groups, groupAddress, newNodes);
            this.nodeCount = this.nodeCountStack.pop() + (isNode ? 1 : newNodes);
            this.parent = this.parent(this.groups, groupIndex);
        } else {
            boolean value$iv = currentGroup == currentGroupEnd;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Expected to be at the end of a group";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            int oldGroupSize = SlotTableKt.access$groupSize(this.groups, groupAddress);
            int oldNodes = SlotTableKt.access$nodeCount(this.groups, groupAddress);
            SlotTableKt.access$updateGroupSize(this.groups, groupAddress, newGroupSize);
            SlotTableKt.access$updateNodeCount(this.groups, groupAddress, newNodes);
            int newParent = this.startStack.pop();
            this.restoreCurrentGroupEnd();
            this.parent = newParent;
            int groupParent = this.parent(this.groups, groupIndex);
            this.nodeCount = this.nodeCountStack.pop();
            if (groupParent == newParent) {
                this.nodeCount += isNode ? 0 : newNodes - oldNodes;
            } else {
                int nodesDelta;
                int groupSizeDelta = newGroupSize - oldGroupSize;
                int n = nodesDelta = isNode ? 0 : newNodes - oldNodes;
                if (groupSizeDelta != 0 || nodesDelta != 0) {
                    int current = groupParent;
                    while (current != 0 && current != newParent && (nodesDelta != 0 || groupSizeDelta != 0)) {
                        int currentAddress = this.groupIndexToAddress(current);
                        if (groupSizeDelta != 0) {
                            int newSize = SlotTableKt.access$groupSize(this.groups, currentAddress) + groupSizeDelta;
                            SlotTableKt.access$updateGroupSize(this.groups, currentAddress, newSize);
                        }
                        if (nodesDelta != 0) {
                            SlotTableKt.access$updateNodeCount(this.groups, currentAddress, SlotTableKt.access$nodeCount(this.groups, currentAddress) + nodesDelta);
                        }
                        if (SlotTableKt.access$isNode(this.groups, currentAddress)) {
                            nodesDelta = 0;
                        }
                        current = this.parent(this.groups, current);
                    }
                }
                this.nodeCount += nodesDelta;
            }
        }
        return newNodes;
    }

    public final void bashGroup$runtime_release() {
        this.startGroup();
        while (!this.isGroupEnd()) {
            this.insertParentGroup(-3);
            this.skipGroup();
        }
        this.endGroup();
    }

    public final void ensureStarted(int index) {
        boolean value$iv = this.insertCount <= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot call ensureStarted() while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int parent = this.parent;
        if (parent != index) {
            boolean value$iv2 = index >= parent && index < this.currentGroupEnd;
            boolean $i$f$runtimeCheck2 = false;
            if (!value$iv2) {
                boolean bl = false;
                String message$iv = "Started group at " + index + " must be a subgroup of the group at " + parent;
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            int oldCurrent = this.currentGroup;
            int oldCurrentSlot = this.currentSlot;
            int oldCurrentSlotEnd = this.currentSlotEnd;
            this.currentGroup = index;
            this.startGroup();
            this.currentGroup = oldCurrent;
            this.currentSlot = oldCurrentSlot;
            this.currentSlotEnd = oldCurrentSlotEnd;
        }
    }

    public final void ensureStarted(@NotNull Anchor anchor) {
        this.ensureStarted(anchor.toIndexFor(this));
    }

    public final int skipGroup() {
        int newGroup;
        int groupAddress = this.groupIndexToAddress(this.currentGroup);
        this.currentGroup = newGroup = this.currentGroup + SlotTableKt.access$groupSize(this.groups, groupAddress);
        this.currentSlot = this.dataIndex(this.groups, this.groupIndexToAddress(newGroup));
        return SlotTableKt.access$isNode(this.groups, groupAddress) ? 1 : SlotTableKt.access$nodeCount(this.groups, groupAddress);
    }

    public final boolean removeGroup() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot remove group while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int oldGroup = this.currentGroup;
        int oldSlot = this.currentSlot;
        int count = this.skipGroup();
        PrioritySet prioritySet = this.pendingRecalculateMarks;
        if (prioritySet != null) {
            PrioritySet it = prioritySet;
            boolean bl = false;
            while (it.isNotEmpty() && it.peek() >= oldGroup) {
                it.takeMax();
            }
        }
        boolean anchorsRemoved = this.removeGroups(oldGroup, this.currentGroup - oldGroup);
        this.removeSlots(oldSlot, this.currentSlot - oldSlot, oldGroup - 1);
        this.currentGroup = oldGroup;
        this.currentSlot = oldSlot;
        this.nodeCount -= count;
        return anchorsRemoved;
    }

    @NotNull
    public final Iterator<Object> groupSlots() {
        int start = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup));
        int end2 = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup + this.groupSize(this.currentGroup)));
        return new Iterator<Object>(start, end2, this){
            private int current;
            final /* synthetic */ int $end;
            final /* synthetic */ SlotWriter this$0;
            {
                this.$end = $end;
                this.this$0 = $receiver;
                this.current = $start;
            }

            public final int getCurrent() {
                return this.current;
            }

            public final void setCurrent(int n) {
                this.current = n;
            }

            public boolean hasNext() {
                return this.current < this.$end;
            }

            @Nullable
            public Object next() {
                Object object;
                if (this.hasNext()) {
                    int n = this.current;
                    this.current = n + 1;
                    object = SlotWriter.access$getSlots$p(this.this$0)[SlotWriter.access$dataIndexToDataAddress(this.this$0, n)];
                } else {
                    object = null;
                }
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void forEachData(int group, @NotNull Function2<? super Integer, Object, Unit> block) {
        boolean $i$f$forEachData = false;
        int address = this.groupIndexToAddress(group);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(group + 1));
        for (int slot = slotsStart; slot < slotsEnd; ++slot) {
            block.invoke((Object)(slot - slotsStart), this.slots[this.dataIndexToDataAddress(slot)]);
        }
    }

    public final void moveGroup(int offset) {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot move a group while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        value$iv = offset >= 0;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Parameter offset is out of bounds";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (offset == 0) {
            return;
        }
        int current = this.currentGroup;
        int parent = this.parent;
        int parentEnd = this.currentGroupEnd;
        int groupToMove = current;
        for (int count = offset; count > 0; --count) {
            boolean value$iv2 = (groupToMove += SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(groupToMove))) <= parentEnd;
            boolean $i$f$runtimeCheck2 = false;
            if (value$iv2) continue;
            boolean bl = false;
            String message$iv = "Parameter offset is out of bounds";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int moveLen = SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(groupToMove));
        int currentSlot = this.currentSlot;
        int dataStart = this.dataIndex(this.groups, this.groupIndexToAddress(groupToMove));
        int dataEnd = this.dataIndex(this.groups, this.groupIndexToAddress(groupToMove + moveLen));
        int moveDataLen = dataEnd - dataStart;
        this.insertSlots(moveDataLen, Math.max(this.currentGroup - 1, 0));
        this.insertGroups(moveLen);
        int[] groups = this.groups;
        int moveLocationAddress = this.groupIndexToAddress(groupToMove + moveLen);
        int moveLocationOffset = moveLocationAddress * 5;
        int currentAddress = this.groupIndexToAddress(current);
        ArraysKt.copyInto((int[])groups, (int[])groups, (int)(currentAddress * 5), (int)moveLocationOffset, (int)(moveLocationOffset + moveLen * 5));
        if (moveDataLen > 0) {
            Object[] slots = this.slots;
            ArraysKt.copyInto((Object[])slots, (Object[])slots, (int)currentSlot, (int)this.dataIndexToDataAddress(dataStart + moveDataLen), (int)this.dataIndexToDataAddress(dataEnd + moveDataLen));
        }
        int dataMoveDistance = dataStart + moveDataLen - currentSlot;
        int slotsGapStart = this.slotsGapStart;
        int slotsGapLen = this.slotsGapLen;
        int slotsCapacity = this.slots.length;
        int slotsGapOwner = this.slotsGapOwner;
        int n = current + moveLen;
        for (int group = current; group < n; ++group) {
            int groupAddress = this.groupIndexToAddress(group);
            int oldIndex = this.dataIndex(groups, groupAddress);
            int newIndex = oldIndex - dataMoveDistance;
            int newAnchor = this.dataIndexToDataAnchor(newIndex, slotsGapOwner < groupAddress ? 0 : slotsGapStart, slotsGapLen, slotsCapacity);
            this.updateDataIndex(groups, groupAddress, newAnchor);
        }
        this.moveAnchors(groupToMove + moveLen, current, moveLen);
        boolean anchorsRemoved = this.removeGroups(groupToMove + moveLen, moveLen);
        boolean value$iv3 = !anchorsRemoved;
        boolean $i$f$runtimeCheck3 = false;
        if (!value$iv3) {
            boolean bl = false;
            String message$iv = "Unexpectedly removed anchors";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.fixParentAnchorsFor(parent, this.currentGroupEnd, current);
        if (moveDataLen > 0) {
            this.removeSlots(dataStart + moveDataLen, moveDataLen, groupToMove + moveLen - 1);
        }
    }

    @NotNull
    public final List<Anchor> moveTo(@NotNull Anchor anchor, int offset, @NotNull SlotWriter writer) {
        boolean updatingNodes;
        ComposerKt.runtimeCheck(writer.insertCount > 0);
        ComposerKt.runtimeCheck(this.insertCount == 0);
        ComposerKt.runtimeCheck(anchor.getValid());
        int location = this.anchorIndex(anchor) + offset;
        int currentGroup = this.currentGroup;
        ComposerKt.runtimeCheck(currentGroup <= location ? location < this.currentGroupEnd : false);
        int parent = this.parent(location);
        int size = this.groupSize(location);
        int nodes = this.isNode(location) ? 1 : this.nodeCount(location);
        List result2 = androidx.compose.runtime.SlotWriter$Companion.moveGroup$default(Companion, this, location, writer, false, false, false, 32, null);
        this.updateContainsMark(parent);
        int current = parent;
        boolean bl = updatingNodes = nodes > 0;
        while (current >= currentGroup) {
            int currentAddress = this.groupIndexToAddress(current);
            SlotTableKt.access$updateGroupSize(this.groups, currentAddress, SlotTableKt.access$groupSize(this.groups, currentAddress) - size);
            if (updatingNodes) {
                if (SlotTableKt.access$isNode(this.groups, currentAddress)) {
                    updatingNodes = false;
                } else {
                    SlotTableKt.access$updateNodeCount(this.groups, currentAddress, SlotTableKt.access$nodeCount(this.groups, currentAddress) - nodes);
                }
            }
            current = this.parent(current);
        }
        if (updatingNodes) {
            ComposerKt.runtimeCheck(this.nodeCount >= nodes);
            this.nodeCount -= nodes;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Anchor> moveFrom(@NotNull SlotTable table, int index, boolean removeSourceGroup) {
        List list;
        ComposerKt.runtimeCheck(this.insertCount > 0);
        if (index == 0 && this.currentGroup == 0 && this.table.getGroupsSize() == 0 && SlotTableKt.access$groupSize(table.getGroups(), index) == table.getGroupsSize()) {
            int[] myGroups = this.groups;
            Object[] mySlots = this.slots;
            ArrayList<Anchor> myAnchors = this.anchors;
            int[] groups = table.getGroups();
            int groupsSize = table.getGroupsSize();
            Object[] slots = table.getSlots();
            int slotsSize = table.getSlotsSize();
            this.groups = groups;
            this.slots = slots;
            this.anchors = table.getAnchors$runtime_release();
            this.groupGapStart = groupsSize;
            this.groupGapLen = groups.length / 5 - groupsSize;
            this.slotsGapStart = slotsSize;
            this.slotsGapLen = slots.length - slotsSize;
            this.slotsGapOwner = groupsSize;
            table.setTo$runtime_release(myGroups, 0, mySlots, 0, myAnchors);
            return this.anchors;
        }
        SlotTable this_$iv = table;
        boolean $i$f$write = false;
        boolean bl = false;
        try (SlotWriter writer$iv = this_$iv.openWriter();){
            SlotWriter tableWriter = writer$iv;
            boolean bl2 = false;
            list = SlotWriter.Companion.moveGroup(tableWriter, index, this, true, true, removeSourceGroup);
        }
        return list;
    }

    public static /* synthetic */ List moveFrom$default(SlotWriter slotWriter, SlotTable slotTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return slotWriter.moveFrom(slotTable, n, bl);
    }

    public final void insertParentGroup(int key) {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Writer cannot be inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (this.isGroupEnd()) {
            this.beginInsert();
            this.startGroup(key);
            this.endGroup();
            this.endInsert();
        } else {
            int newChildAddress;
            int currentGroup = this.currentGroup;
            int parent = this.parent(this.groups, currentGroup);
            int currentGroupEnd = parent + this.groupSize(parent);
            int remainingSize = currentGroupEnd - currentGroup;
            int nodeCount = 0;
            for (int currentNewChild = currentGroup; currentNewChild < currentGroupEnd; currentNewChild += SlotTableKt.access$groupSize(this.groups, newChildAddress)) {
                newChildAddress = this.groupIndexToAddress(currentNewChild);
                nodeCount += SlotTableKt.access$nodeCount(this.groups, newChildAddress);
            }
            int currentSlot = SlotTableKt.access$dataAnchor(this.groups, this.groupIndexToAddress(currentGroup));
            this.beginInsert();
            this.insertGroups(1);
            this.endInsert();
            int currentAddress = this.groupIndexToAddress(currentGroup);
            SlotTableKt.access$initGroup(this.groups, currentAddress, key, false, false, false, parent, currentSlot);
            SlotTableKt.access$updateGroupSize(this.groups, currentAddress, remainingSize + 1);
            SlotTableKt.access$updateNodeCount(this.groups, currentAddress, nodeCount);
            int parentAddress = this.groupIndexToAddress(parent);
            this.addToGroupSizeAlongSpine(parentAddress, 1);
            this.fixParentAnchorsFor(parent, currentGroupEnd, currentGroup);
            this.currentGroup = currentGroupEnd;
        }
    }

    public final void addToGroupSizeAlongSpine(int address, int amount) {
        int current = address;
        while (current > 0) {
            int parentAddress;
            SlotTableKt.access$updateGroupSize(this.groups, current, SlotTableKt.access$groupSize(this.groups, current) + amount);
            int parentAnchor = SlotTableKt.access$parentAnchor(this.groups, current);
            int parentGroup = this.parentAnchorToIndex(parentAnchor);
            current = parentAddress = this.groupIndexToAddress(parentGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Anchor> moveIntoGroupFrom(int offset, @NotNull SlotTable table, int index) {
        List list;
        ComposerKt.runtimeCheck(this.insertCount <= 0 && this.groupSize(this.currentGroup + offset) == 1);
        int previousCurrentGroup = this.currentGroup;
        int previousCurrentSlot = this.currentSlot;
        int previousCurrentSlotEnd = this.currentSlotEnd;
        this.advanceBy(offset);
        this.startGroup();
        this.beginInsert();
        SlotTable this_$iv = table;
        boolean $i$f$write = false;
        boolean bl = false;
        try (SlotWriter writer$iv = this_$iv.openWriter();){
            SlotWriter tableWriter = writer$iv;
            boolean bl2 = false;
            list = androidx.compose.runtime.SlotWriter$Companion.moveGroup$default(Companion, tableWriter, index, this, false, true, false, 32, null);
        }
        List anchors = list;
        this.endInsert();
        this.endGroup();
        this.currentGroup = previousCurrentGroup;
        this.currentSlot = previousCurrentSlot;
        this.currentSlotEnd = previousCurrentSlotEnd;
        return anchors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.anchors;
        int effectiveSize$iv = this.getSize$runtime_release();
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index <= this.groupGapStart ? index : -(this.getSize$runtime_release() - index));
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            anchor = (Anchor)$this$getOrAdd$iv.get(location$iv);
        }
        return anchor;
    }

    public static /* synthetic */ Anchor anchor$default(SlotWriter slotWriter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotWriter.currentGroup;
        }
        return slotWriter.anchor(n);
    }

    public final void markGroup(int group) {
        int groupAddress = this.groupIndexToAddress(group);
        if (!SlotTableKt.access$hasMark(this.groups, groupAddress)) {
            SlotTableKt.access$updateMark(this.groups, groupAddress, true);
            if (!SlotTableKt.access$containsMark(this.groups, groupAddress)) {
                this.updateContainsMark(this.parent(group));
            }
        }
    }

    public static /* synthetic */ void markGroup$default(SlotWriter slotWriter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotWriter.parent;
        }
        slotWriter.markGroup(n);
    }

    private final boolean containsGroupMark(int group) {
        return group >= 0 && SlotTableKt.access$containsMark(this.groups, this.groupIndexToAddress(group));
    }

    private final boolean containsAnyGroupMarks(int group) {
        return group >= 0 && SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(group));
    }

    private final void recalculateMarks() {
        block1: {
            PrioritySet prioritySet = this.pendingRecalculateMarks;
            if (prioritySet == null) break block1;
            PrioritySet set = prioritySet;
            boolean bl = false;
            while (set.isNotEmpty()) {
                this.updateContainsMarkNow(set.takeMax(), set);
            }
        }
    }

    private final void updateContainsMark(int group) {
        if (group >= 0) {
            PrioritySet prioritySet = this.pendingRecalculateMarks;
            if (prioritySet == null) {
                PrioritySet prioritySet2;
                PrioritySet it = prioritySet2 = new PrioritySet(null, 1, null);
                boolean bl = false;
                this.pendingRecalculateMarks = it;
                prioritySet = prioritySet2;
            }
            prioritySet.add(group);
        }
    }

    private final void updateContainsMarkNow(int group, PrioritySet set) {
        boolean markChanges;
        int groupAddress = this.groupIndexToAddress(group);
        boolean containsAnyMarks = this.childContainsAnyMarks(group);
        boolean bl = markChanges = SlotTableKt.access$containsMark(this.groups, groupAddress) != containsAnyMarks;
        if (markChanges) {
            SlotTableKt.access$updateContainsMark(this.groups, groupAddress, containsAnyMarks);
            int parent = this.parent(group);
            if (parent >= 0) {
                set.add(parent);
            }
        }
    }

    private final boolean childContainsAnyMarks(int group) {
        int end2 = group + this.groupSize(group);
        for (int child = group + 1; child < end2; child += this.groupSize(child)) {
            if (!SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(child))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int anchorIndex(@NotNull Anchor anchor) {
        void var2_2;
        int it = anchor.getLocation$runtime_release();
        boolean bl = false;
        return it < 0 ? this.getSize$runtime_release() + it : var2_2;
    }

    @NotNull
    public String toString() {
        return "SlotWriter(current = " + this.currentGroup + " end=" + this.currentGroupEnd + " size = " + this.getSize$runtime_release() + " gap=" + this.groupGapStart + '-' + (this.groupGapStart + this.groupGapLen) + ')';
    }

    private final void saveCurrentGroupEnd() {
        this.endStack.push(this.getCapacity() - this.groupGapLen - this.currentGroupEnd);
    }

    private final int restoreCurrentGroupEnd() {
        int newGroupEnd;
        this.currentGroupEnd = newGroupEnd = this.getCapacity() - this.groupGapLen - this.endStack.pop();
        return newGroupEnd;
    }

    private final void fixParentAnchorsFor(int parent, int endGroup, int firstChild) {
        int parentAnchor = this.parentIndexToAnchor(parent, this.groupGapStart);
        int child = firstChild;
        while (child < endGroup) {
            SlotTableKt.access$updateParentAnchor(this.groups, this.groupIndexToAddress(child), parentAnchor);
            int childEnd = child + SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(child));
            this.fixParentAnchorsFor(child, childEnd, child + 1);
            child = childEnd;
        }
    }

    private final void moveGroupGapTo(int index) {
        int gapLen = this.groupGapLen;
        int gapStart = this.groupGapStart;
        if (gapStart != index) {
            if (!((Collection)this.anchors).isEmpty()) {
                this.updateAnchors(gapStart, index);
            }
            if (gapLen > 0) {
                int[] groups = this.groups;
                int groupPhysicalAddress = index * 5;
                int groupPhysicalGapLen = gapLen * 5;
                int groupPhysicalGapStart = gapStart * 5;
                if (index < gapStart) {
                    ArraysKt.copyInto((int[])groups, (int[])groups, (int)(groupPhysicalAddress + groupPhysicalGapLen), (int)groupPhysicalAddress, (int)groupPhysicalGapStart);
                } else {
                    ArraysKt.copyInto((int[])groups, (int[])groups, (int)groupPhysicalGapStart, (int)(groupPhysicalGapStart + groupPhysicalGapLen), (int)(groupPhysicalAddress + groupPhysicalGapLen));
                }
            }
            int groupAddress = index < gapStart ? index + gapLen : gapStart;
            int capacity = this.getCapacity();
            ComposerKt.runtimeCheck(groupAddress < capacity);
            while (groupAddress < capacity) {
                int oldAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
                int oldIndex = this.parentAnchorToIndex(oldAnchor);
                int newAnchor = this.parentIndexToAnchor(oldIndex, index);
                if (newAnchor != oldAnchor) {
                    SlotTableKt.access$updateParentAnchor(this.groups, groupAddress, newAnchor);
                }
                if (++groupAddress != index) continue;
                groupAddress += gapLen;
            }
        }
        this.groupGapStart = index;
    }

    private final void moveSlotGapTo(int index, int group) {
        int newSlotsGapOwner;
        int gapLen = this.slotsGapLen;
        int gapStart = this.slotsGapStart;
        int slotsGapOwner = this.slotsGapOwner;
        if (gapStart != index) {
            Object[] slots = this.slots;
            if (index < gapStart) {
                ArraysKt.copyInto((Object[])slots, (Object[])slots, (int)(index + gapLen), (int)index, (int)gapStart);
            } else {
                ArraysKt.copyInto((Object[])slots, (Object[])slots, (int)gapStart, (int)(gapStart + gapLen), (int)(index + gapLen));
            }
        }
        if (slotsGapOwner != (newSlotsGapOwner = Math.min(group + 1, this.getSize$runtime_release()))) {
            int slotsSize = this.slots.length - gapLen;
            if (newSlotsGapOwner < slotsGapOwner) {
                int updateAddress = this.groupIndexToAddress(newSlotsGapOwner);
                int stopUpdateAddress = this.groupIndexToAddress(slotsGapOwner);
                int groupGapStart = this.groupGapStart;
                while (updateAddress < stopUpdateAddress) {
                    int anchor = SlotTableKt.access$dataAnchor(this.groups, updateAddress);
                    boolean value$iv = anchor >= 0;
                    boolean $i$f$runtimeCheck = false;
                    if (!value$iv) {
                        boolean bl = false;
                        String message$iv = "Unexpected anchor value, expected a positive anchor";
                        ComposerKt.composeRuntimeError(message$iv.toString());
                        throw new KotlinNothingValueException();
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, updateAddress, -(slotsSize - anchor + 1));
                    if (++updateAddress != groupGapStart) continue;
                    updateAddress += this.groupGapLen;
                }
            } else {
                int updateAddress = this.groupIndexToAddress(slotsGapOwner);
                int stopUpdateAddress = this.groupIndexToAddress(newSlotsGapOwner);
                while (updateAddress < stopUpdateAddress) {
                    int anchor = SlotTableKt.access$dataAnchor(this.groups, updateAddress);
                    boolean value$iv = anchor < 0;
                    boolean $i$f$runtimeCheck = false;
                    if (!value$iv) {
                        boolean bl = false;
                        String message$iv = "Unexpected anchor value, expected a negative anchor";
                        ComposerKt.composeRuntimeError(message$iv.toString());
                        throw new KotlinNothingValueException();
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, updateAddress, slotsSize + anchor + 1);
                    if (++updateAddress != this.groupGapStart) continue;
                    updateAddress += this.groupGapLen;
                }
            }
            this.slotsGapOwner = newSlotsGapOwner;
        }
        this.slotsGapStart = index;
    }

    private final void clearSlotGap() {
        int slotsGapStart = this.slotsGapStart;
        int slotsGapEnd = slotsGapStart + this.slotsGapLen;
        ArraysKt.fill((Object[])this.slots, null, (int)slotsGapStart, (int)slotsGapEnd);
    }

    private final void insertGroups(int size) {
        if (size > 0) {
            int currentEnd;
            int currentGroup = this.currentGroup;
            this.moveGroupGapTo(currentGroup);
            int gapStart = this.groupGapStart;
            int gapLen = this.groupGapLen;
            int oldCapacity = this.groups.length / 5;
            int oldSize = oldCapacity - gapLen;
            if (gapLen < size) {
                int[] groups = this.groups;
                int newCapacity = Math.max(Math.max(oldCapacity * 2, oldSize + size), 32);
                int[] newGroups = new int[newCapacity * 5];
                int newGapLen = newCapacity - oldSize;
                int oldGapEndAddress = gapStart + gapLen;
                int newGapEndAddress = gapStart + newGapLen;
                ArraysKt.copyInto((int[])groups, (int[])newGroups, (int)0, (int)0, (int)(gapStart * 5));
                ArraysKt.copyInto((int[])groups, (int[])newGroups, (int)(newGapEndAddress * 5), (int)(oldGapEndAddress * 5), (int)(oldCapacity * 5));
                this.groups = newGroups;
                gapLen = newGapLen;
            }
            if ((currentEnd = this.currentGroupEnd) >= gapStart) {
                this.currentGroupEnd = currentEnd + size;
            }
            this.groupGapStart = gapStart + size;
            this.groupGapLen = gapLen - size;
            int index = oldSize > 0 ? this.dataIndex(currentGroup + size) : 0;
            int anchor = this.dataIndexToDataAnchor(index, this.slotsGapOwner < gapStart ? 0 : this.slotsGapStart, this.slotsGapLen, this.slots.length);
            int n = gapStart + size;
            for (int groupAddress = gapStart; groupAddress < n; ++groupAddress) {
                SlotTableKt.access$updateDataAnchor(this.groups, groupAddress, anchor);
            }
            int slotsGapOwner = this.slotsGapOwner;
            if (slotsGapOwner >= gapStart) {
                this.slotsGapOwner = slotsGapOwner + size;
            }
        }
    }

    private final void insertSlots(int size, int group) {
        if (size > 0) {
            int currentDataEnd;
            this.moveSlotGapTo(this.currentSlot, group);
            int gapStart = this.slotsGapStart;
            int gapLen = this.slotsGapLen;
            if (gapLen < size) {
                Object[] slots = this.slots;
                int oldCapacity = slots.length;
                int oldSize = oldCapacity - gapLen;
                int newCapacity = Math.max(Math.max(oldCapacity * 2, oldSize + size), 32);
                int n = 0;
                Object[] objectArray = new Object[newCapacity];
                while (n < newCapacity) {
                    int n2 = n++;
                    objectArray[n2] = null;
                }
                Object[] newData = objectArray;
                int newGapLen = newCapacity - oldSize;
                int oldGapEndAddress = gapStart + gapLen;
                int newGapEndAddress = gapStart + newGapLen;
                ArraysKt.copyInto((Object[])slots, (Object[])newData, (int)0, (int)0, (int)gapStart);
                ArraysKt.copyInto((Object[])slots, (Object[])newData, (int)newGapEndAddress, (int)oldGapEndAddress, (int)oldCapacity);
                this.slots = newData;
                gapLen = newGapLen;
            }
            if ((currentDataEnd = this.currentSlotEnd) >= gapStart) {
                this.currentSlotEnd = currentDataEnd + size;
            }
            this.slotsGapStart = gapStart + size;
            this.slotsGapLen = gapLen - size;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeGroups(int start, int len) {
        boolean bl;
        if (len > 0) {
            void var3_3;
            int newGapLen;
            boolean anchorsRemoved = false;
            ArrayList<Anchor> anchors = this.anchors;
            this.moveGroupGapTo(start);
            if (!((Collection)anchors).isEmpty()) {
                anchorsRemoved = this.removeAnchors(start, len);
            }
            this.groupGapStart = start;
            int previousGapLen = this.groupGapLen;
            this.groupGapLen = newGapLen = previousGapLen + len;
            int slotsGapOwner = this.slotsGapOwner;
            if (slotsGapOwner > start) {
                this.slotsGapOwner = Math.max(start, slotsGapOwner - len);
            }
            if (this.currentGroupEnd >= this.groupGapStart) {
                this.currentGroupEnd -= len;
            }
            if (this.containsGroupMark(this.parent)) {
                this.updateContainsMark(this.parent);
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void removeSlots(int start, int len, int group) {
        if (len > 0) {
            int gapLen = this.slotsGapLen;
            int removeEnd = start + len;
            this.moveSlotGapTo(removeEnd, group);
            this.slotsGapStart = start;
            this.slotsGapLen = gapLen + len;
            ArraysKt.fill((Object[])this.slots, null, (int)start, (int)(start + len));
            int currentDataEnd = this.currentSlotEnd;
            if (currentDataEnd >= start) {
                this.currentSlotEnd = currentDataEnd - len;
            }
        }
    }

    private final void updateNodeOfGroup(int index, Object value) {
        int address = this.groupIndexToAddress(index);
        boolean value$iv = address < this.groups.length && SlotTableKt.access$isNode(this.groups, address);
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Updating the node of a group at " + index + " that was not created with as a node group";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)this.nodeIndex((int[])this.groups, (int)address))] = value;
    }

    private final void updateAnchors(int previousGapStart, int newGapStart) {
        int gapLen = this.groupGapLen;
        int size = this.getCapacity() - gapLen;
        if (previousGapStart < newGapStart) {
            int newLocation;
            Anchor anchor;
            int location;
            for (int index = SlotTableKt.access$locationOf(this.anchors, previousGapStart, size); index < this.anchors.size() && (location = (anchor = this.anchors.get(index)).getLocation$runtime_release()) < 0 && (newLocation = size + location) < newGapStart; ++index) {
                anchor.setLocation$runtime_release(size + location);
            }
        } else {
            Anchor anchor;
            int location;
            for (int index = SlotTableKt.access$locationOf(this.anchors, newGapStart, size); index < this.anchors.size() && (location = (anchor = this.anchors.get(index)).getLocation$runtime_release()) >= 0; ++index) {
                anchor.setLocation$runtime_release(-(size - location));
            }
        }
    }

    private final boolean removeAnchors(int gapStart, int size) {
        boolean bl;
        Anchor anchor;
        int location;
        int index;
        int gapLen = this.groupGapLen;
        int removeEnd = gapStart + size;
        int groupsSize = this.getCapacity() - gapLen;
        int it = SlotTableKt.access$locationOf(this.anchors, gapStart + size, groupsSize);
        boolean bl2 = false;
        int n = it >= this.anchors.size() ? it - 1 : it;
        int removeAnchorEnd = 0;
        int removeAnchorStart = 0;
        removeAnchorStart = index + 1;
        for (index = v42828; index >= 0 && (location = this.anchorIndex(anchor = this.anchors.get(index))) >= gapStart; --index) {
            if (location >= removeEnd) continue;
            anchor.setLocation$runtime_release(Integer.MIN_VALUE);
            removeAnchorStart = index;
            if (removeAnchorEnd != 0) continue;
            removeAnchorEnd = index + 1;
        }
        boolean it2 = bl = removeAnchorStart < removeAnchorEnd;
        boolean bl3 = false;
        if (it2) {
            this.anchors.subList(removeAnchorStart, removeAnchorEnd).clear();
        }
        return bl;
    }

    private final void moveAnchors(int originalLocation, int newLocation, int size) {
        int end2 = originalLocation + size;
        int groupsSize = this.getSize$runtime_release();
        int index = SlotTableKt.access$locationOf(this.anchors, originalLocation, groupsSize);
        List removedAnchors = new ArrayList();
        if (index >= 0) {
            Anchor anchor;
            int location;
            while (index < this.anchors.size() && (location = this.anchorIndex(anchor = this.anchors.get(index))) >= originalLocation && location < end2) {
                removedAnchors.add(anchor);
                this.anchors.remove(index);
            }
        }
        int moveDelta = newLocation - originalLocation;
        List $this$fastForEach$iv = removedAnchors;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            Anchor anchor = (Anchor)item$iv;
            boolean bl = false;
            int anchorIndex = this.anchorIndex(anchor);
            int newAnchorIndex = anchorIndex + moveDelta;
            if (newAnchorIndex >= this.groupGapStart) {
                anchor.setLocation$runtime_release(-(groupsSize - newAnchorIndex));
            } else {
                anchor.setLocation$runtime_release(newAnchorIndex);
            }
            int insertIndex = SlotTableKt.access$locationOf(this.anchors, newAnchorIndex, groupsSize);
            this.anchors.add(insertIndex, anchor);
        }
    }

    @NotNull
    public final String groupsAsString() {
        StringBuilder stringBuilder;
        StringBuilder $this$groupsAsString_u24lambda_u2435 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.getSize$runtime_release();
        for (int index = 0; index < n; ++index) {
            this.groupAsString($this$groupsAsString_u24lambda_u2435, index);
            $this$groupsAsString_u24lambda_u2435.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void groupAsString(StringBuilder $this$groupAsString, int index) {
        int address = this.groupIndexToAddress(index);
        $this$groupAsString.append("Group(");
        if (index < 10) {
            $this$groupAsString.append(' ');
        }
        if (index < 100) {
            $this$groupAsString.append(' ');
        }
        if (index < 1000) {
            $this$groupAsString.append(' ');
        }
        $this$groupAsString.append(index);
        if (address != index) {
            $this$groupAsString.append("(");
            $this$groupAsString.append(address);
            $this$groupAsString.append(")");
        }
        $this$groupAsString.append('#');
        $this$groupAsString.append(SlotTableKt.access$groupSize(this.groups, address));
        boolean openGroup = SlotWriter.groupAsString$isStarted(this, index);
        if (openGroup) {
            $this$groupAsString.append('?');
        }
        $this$groupAsString.append('^');
        $this$groupAsString.append(this.parentAnchorToIndex(SlotTableKt.access$parentAnchor(this.groups, address)));
        $this$groupAsString.append(": key=");
        $this$groupAsString.append(SlotTableKt.access$key(this.groups, address));
        $this$groupAsString.append(", nodes=");
        $this$groupAsString.append(SlotTableKt.access$nodeCount(this.groups, address));
        if (openGroup) {
            $this$groupAsString.append('?');
        }
        $this$groupAsString.append(", dataAnchor=");
        $this$groupAsString.append(SlotTableKt.access$dataAnchor(this.groups, address));
        $this$groupAsString.append(", parentAnchor=");
        $this$groupAsString.append(SlotTableKt.access$parentAnchor(this.groups, address));
        if (SlotTableKt.access$isNode(this.groups, address)) {
            $this$groupAsString.append(", node=" + this.slots[this.dataIndexToDataAddress(this.nodeIndex(this.groups, address))]);
        }
        int startData = this.slotIndex(this.groups, address);
        int endData = this.dataIndex(this.groups, address + 1);
        if (endData > startData) {
            $this$groupAsString.append(", [");
            for (int dataIndex = startData; dataIndex < endData; ++dataIndex) {
                if (dataIndex != startData) {
                    $this$groupAsString.append(", ");
                }
                int dataAddress = this.dataIndexToDataAddress(dataIndex);
                $this$groupAsString.append(String.valueOf(this.slots[dataAddress]));
            }
            $this$groupAsString.append(']');
        }
        $this$groupAsString.append(")");
    }

    public final void verifyDataAnchors$runtime_release() {
        int previousDataIndex = 0;
        int owner = this.slotsGapOwner;
        boolean ownerFound = false;
        int slotsSize = this.slots.length - this.slotsGapLen;
        int n = this.getSize$runtime_release();
        for (int index = 0; index < n; ++index) {
            int address = this.groupIndexToAddress(index);
            int dataAnchor = SlotTableKt.access$dataAnchor(this.groups, address);
            int dataIndex = this.dataIndex(this.groups, address);
            if (!(dataIndex >= previousDataIndex)) {
                boolean $i$a$-check-SlotWriter$verifyDataAnchors$42 = false;
                String $i$a$-check-SlotWriter$verifyDataAnchors$42 = "Data index out of order at " + index + ", previous = " + previousDataIndex + ", current = " + dataIndex;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyDataAnchors$42.toString());
            }
            if (!(dataIndex <= slotsSize)) {
                boolean $i$a$-check-SlotWriter$verifyDataAnchors$52 = false;
                String $i$a$-check-SlotWriter$verifyDataAnchors$52 = "Data index, " + dataIndex + ", out of bound at " + index;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyDataAnchors$52.toString());
            }
            if (dataAnchor < 0 && !ownerFound) {
                if (!(owner == index)) {
                    boolean bl = false;
                    String string = "Expected the slot gap owner to be " + owner + " found gap at " + index;
                    throw new IllegalStateException(string.toString());
                }
                ownerFound = true;
            }
            previousDataIndex = dataIndex;
        }
    }

    public final void verifyParentAnchors$runtime_release() {
        int parentAnchor;
        int groupAddress;
        int gapStart = this.groupGapStart;
        int gapLen = this.groupGapLen;
        int capacity = this.getCapacity();
        for (groupAddress = 0; groupAddress < gapStart; ++groupAddress) {
            parentAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
            if (parentAnchor > -2) continue;
            boolean bl = false;
            String string = "Expected a start relative anchor at " + groupAddress;
            throw new IllegalStateException(string.toString());
        }
        for (groupAddress = gapStart + gapLen; groupAddress < capacity; ++groupAddress) {
            parentAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
            int parentIndex = this.parentAnchorToIndex(parentAnchor);
            if (parentIndex < gapStart) {
                if (parentAnchor > -2) continue;
                boolean $i$a$-check-SlotWriter$verifyParentAnchors$42 = false;
                String $i$a$-check-SlotWriter$verifyParentAnchors$42 = "Expected a start relative anchor at " + groupAddress;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyParentAnchors$42.toString());
            }
            if (parentAnchor <= -2) continue;
            boolean bl = false;
            String string = "Expected an end relative anchor at " + groupAddress;
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getSize$runtime_release() {
        return this.getCapacity() - this.groupGapLen;
    }

    private final int getCapacity() {
        return this.groups.length / 5;
    }

    private final int groupIndexToAddress(int index) {
        return index < this.groupGapStart ? index : index + this.groupGapLen;
    }

    private final int dataIndexToDataAddress(int dataIndex) {
        return dataIndex < this.slotsGapStart ? dataIndex : dataIndex + this.slotsGapLen;
    }

    private final int parent(int[] $this$parent, int index) {
        return this.parentAnchorToIndex(SlotTableKt.access$parentAnchor($this$parent, this.groupIndexToAddress(index)));
    }

    private final int dataIndex(int index) {
        return this.dataIndex(this.groups, this.groupIndexToAddress(index));
    }

    private final int dataIndex(int[] $this$dataIndex, int address) {
        return address >= this.getCapacity() ? this.slots.length - this.slotsGapLen : this.dataAnchorToDataIndex(SlotTableKt.access$dataAnchor($this$dataIndex, address), this.slotsGapLen, this.slots.length);
    }

    private final int slotIndex(int[] $this$slotIndex, int address) {
        return address >= this.getCapacity() ? this.slots.length - this.slotsGapLen : this.dataAnchorToDataIndex(SlotTableKt.access$slotAnchor($this$slotIndex, address), this.slotsGapLen, this.slots.length);
    }

    private final void updateDataIndex(int[] $this$updateDataIndex, int address, int dataIndex) {
        SlotTableKt.access$updateDataAnchor($this$updateDataIndex, address, this.dataIndexToDataAnchor(dataIndex, this.slotsGapStart, this.slotsGapLen, this.slots.length));
    }

    private final int nodeIndex(int[] $this$nodeIndex, int address) {
        return this.dataIndex($this$nodeIndex, address);
    }

    private final int auxIndex(int[] $this$auxIndex, int address) {
        return this.dataIndex($this$auxIndex, address) + SlotTableKt.access$countOneBits(SlotTableKt.access$groupInfo($this$auxIndex, address) >> 29);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> dataIndexes(int[] $this$dataIndexes) {
        List it = SlotTableKt.dataAnchors$default(this.groups, 0, 1, null);
        boolean bl = false;
        List $this$fastMap$iv = CollectionsKt.plus((Collection)CollectionsKt.slice((List)it, (IntRange)RangesKt.until((int)0, (int)this.groupGapStart)), (Iterable)CollectionsKt.slice((List)it, (IntRange)RangesKt.until((int)(this.groupGapStart + this.groupGapLen), (int)($this$dataIndexes.length / 5))));
        boolean $i$f$fastMap = false;
        ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
        List $this$fastForEach$iv$iv = $this$fastMap$iv;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void anchor;
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl2 = false;
            int n2 = ((Number)it$iv).intValue();
            Collection collection = target$iv;
            boolean bl3 = false;
            collection.add(this.dataAnchorToDataIndex((int)anchor, this.slotsGapLen, this.slots.length));
        }
        return target$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> keys() {
        List $this$fastFilterIndexed$iv = SlotTableKt.keys$default(this.groups, 0, 1, null);
        boolean $i$f$fastFilterIndexed = false;
        ArrayList target$iv = new ArrayList($this$fastFilterIndexed$iv.size());
        List $this$fastForEachIndexed$iv$iv = $this$fastFilterIndexed$iv;
        boolean $i$f$fastForEachIndexed = false;
        int n = $this$fastForEachIndexed$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void e$iv;
            Object item$iv$iv;
            Object e = item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            int index$iv = index$iv$iv;
            boolean bl = false;
            ((Number)e$iv).intValue();
            int index = index$iv;
            boolean bl2 = false;
            if (!(index < this.groupGapStart || index >= this.groupGapStart + this.groupGapLen)) continue;
            ((Collection)target$iv).add(e$iv);
        }
        return target$iv;
    }

    private final int dataIndexToDataAnchor(int index, int gapStart, int gapLen, int capacity) {
        return index > gapStart ? -(capacity - gapLen - index + 1) : index;
    }

    private final int dataAnchorToDataIndex(int anchor, int gapLen, int capacity) {
        return anchor < 0 ? capacity - gapLen + anchor + 1 : anchor;
    }

    private final int parentIndexToAnchor(int index, int gapStart) {
        return index < gapStart ? index : -(this.getSize$runtime_release() - index - -2);
    }

    private final int parentAnchorToIndex(int index) {
        return index > -2 ? index : this.getSize$runtime_release() + index - -2;
    }

    private static final boolean groupAsString$isStarted(SlotWriter this$0, int index) {
        return index < this$0.currentGroup && (index == this$0.parent || this$0.startStack.indexOf(index) >= 0 || SlotWriter.groupAsString$isStarted(this$0, this$0.parent(index)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Landroidx/compose/runtime/SlotWriter$Companion;", "", "()V", "moveGroup", "", "Landroidx/compose/runtime/Anchor;", "fromWriter", "Landroidx/compose/runtime/SlotWriter;", "fromIndex", "", "toWriter", "updateFromCursor", "", "updateToCursor", "removeSourceGroup", "runtime_release"})
    @SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,3481:1\n1#2:3482\n4105#3,5:3483\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter$Companion\n*L\n2117#1:3483,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Anchor> moveGroup(SlotWriter fromWriter, int fromIndex, SlotWriter toWriter, boolean updateFromCursor, boolean updateToCursor, boolean removeSourceGroup) {
            boolean bl;
            List list;
            void $this$moveGroup_u24lambda_u240;
            int groupsToMove = fromWriter.groupSize(fromIndex);
            int sourceGroupsEnd = fromIndex + groupsToMove;
            int sourceSlotsStart = fromWriter.dataIndex(fromIndex);
            int sourceSlotsEnd = fromWriter.dataIndex(sourceGroupsEnd);
            int slotsToMove = sourceSlotsEnd - sourceSlotsStart;
            boolean hasMarks = fromWriter.containsAnyGroupMarks(fromIndex);
            toWriter.insertGroups(groupsToMove);
            toWriter.insertSlots(slotsToMove, toWriter.getCurrentGroup());
            if (fromWriter.groupGapStart < sourceGroupsEnd) {
                fromWriter.moveGroupGapTo(sourceGroupsEnd);
            }
            if (fromWriter.slotsGapStart < sourceSlotsEnd) {
                fromWriter.moveSlotGapTo(sourceSlotsEnd, sourceGroupsEnd);
            }
            int[] groups = toWriter.groups;
            int currentGroup = toWriter.getCurrentGroup();
            ArraysKt.copyInto((int[])fromWriter.groups, (int[])groups, (int)(currentGroup * 5), (int)(fromIndex * 5), (int)(sourceGroupsEnd * 5));
            Object[] slots = toWriter.slots;
            int currentSlot = toWriter.currentSlot;
            ArraysKt.copyInto((Object[])fromWriter.slots, (Object[])slots, (int)currentSlot, (int)sourceSlotsStart, (int)sourceSlotsEnd);
            int parent = toWriter.getParent();
            SlotTableKt.access$updateParentAnchor(groups, currentGroup, parent);
            int parentDelta = currentGroup - fromIndex;
            int moveEnd = currentGroup + groupsToMove;
            SlotWriter slotWriter = toWriter;
            int n = currentSlot;
            boolean bl2 = false;
            int n2 = ((SlotWriter)$this$moveGroup_u24lambda_u240).dataIndex(groups, currentGroup);
            int dataIndexDelta = n - n2;
            int slotsGapOwner = 0;
            slotsGapOwner = toWriter.slotsGapOwner;
            int slotsGapLen = toWriter.slotsGapLen;
            int slotsCapacity = slots.length;
            for (int groupAddress = currentGroup; groupAddress < moveEnd; ++groupAddress) {
                if (groupAddress != currentGroup) {
                    int previousParent = SlotTableKt.access$parentAnchor(groups, groupAddress);
                    SlotTableKt.access$updateParentAnchor(groups, groupAddress, previousParent + parentDelta);
                }
                SlotWriter $this$moveGroup_u24lambda_u241 = toWriter;
                boolean bl3 = false;
                int newDataIndex = $this$moveGroup_u24lambda_u241.dataIndex(groups, groupAddress) + dataIndexDelta;
                SlotWriter $this$moveGroup_u24lambda_u2432 = toWriter;
                boolean bl4 = false;
                int newDataAnchor = $this$moveGroup_u24lambda_u2432.dataIndexToDataAnchor(newDataIndex, slotsGapOwner < groupAddress ? 0 : $this$moveGroup_u24lambda_u2432.slotsGapStart, slotsGapLen, slotsCapacity);
                SlotTableKt.access$updateDataAnchor(groups, groupAddress, newDataAnchor);
                if (groupAddress != slotsGapOwner) continue;
                int $this$moveGroup_u24lambda_u2432 = slotsGapOwner;
                slotsGapOwner = $this$moveGroup_u24lambda_u2432 + 1;
            }
            toWriter.slotsGapOwner = slotsGapOwner;
            int startAnchors = SlotTableKt.access$locationOf(fromWriter.anchors, fromIndex, fromWriter.getSize$runtime_release());
            int endAnchors = SlotTableKt.access$locationOf(fromWriter.anchors, sourceGroupsEnd, fromWriter.getSize$runtime_release());
            if (startAnchors < endAnchors) {
                ArrayList sourceAnchors = fromWriter.anchors;
                ArrayList<Anchor> anchors = new ArrayList<Anchor>(endAnchors - startAnchors);
                int anchorDelta = currentGroup - fromIndex;
                for (int anchorIndex = startAnchors; anchorIndex < endAnchors; ++anchorIndex) {
                    Anchor sourceAnchor = (Anchor)sourceAnchors.get(anchorIndex);
                    sourceAnchor.setLocation$runtime_release(sourceAnchor.getLocation$runtime_release() + anchorDelta);
                    anchors.add(sourceAnchor);
                }
                int insertLocation = SlotTableKt.access$locationOf(toWriter.anchors, toWriter.getCurrentGroup(), toWriter.getSize$runtime_release());
                toWriter.anchors.addAll(insertLocation, (Collection)anchors);
                sourceAnchors.subList(startAnchors, endAnchors).clear();
                list = anchors;
            } else {
                list = CollectionsKt.emptyList();
            }
            List anchors = list;
            int parentGroup = fromWriter.parent(fromIndex);
            if (!removeSourceGroup) {
                bl = false;
            } else if (updateFromCursor) {
                boolean needsStartGroups;
                boolean bl5 = needsStartGroups = parentGroup >= 0;
                if (needsStartGroups) {
                    fromWriter.startGroup();
                    fromWriter.advanceBy(parentGroup - fromWriter.getCurrentGroup());
                    fromWriter.startGroup();
                }
                fromWriter.advanceBy(fromIndex - fromWriter.getCurrentGroup());
                boolean anchorsRemoved = fromWriter.removeGroup();
                if (needsStartGroups) {
                    fromWriter.skipToGroupEnd();
                    fromWriter.endGroup();
                    fromWriter.skipToGroupEnd();
                    fromWriter.endGroup();
                }
                bl = anchorsRemoved;
            } else {
                boolean anchorsRemoved = fromWriter.removeGroups(fromIndex, groupsToMove);
                fromWriter.removeSlots(sourceSlotsStart, slotsToMove, fromIndex - 1);
                bl = anchorsRemoved;
            }
            boolean anchorsRemoved = bl;
            boolean value$iv = !anchorsRemoved;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl6 = false;
                String message$iv = "Unexpectedly removed anchors";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            toWriter.nodeCount = toWriter.nodeCount + (SlotTableKt.access$isNode(groups, currentGroup) ? 1 : SlotTableKt.access$nodeCount(groups, currentGroup));
            if (updateToCursor) {
                toWriter.currentGroup = currentGroup + groupsToMove;
                toWriter.currentSlot = currentSlot + slotsToMove;
            }
            if (hasMarks) {
                toWriter.updateContainsMark(parent);
            }
            return anchors;
        }

        static /* synthetic */ List moveGroup$default(Companion companion, SlotWriter slotWriter, int n, SlotWriter slotWriter2, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                bl3 = true;
            }
            return companion.moveGroup(slotWriter, n, slotWriter2, bl, bl2, bl3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

