/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.collection.IdentityArraySet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0011\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0002H\u0086\u0002J\u0012\u0010\"\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\fH\u0002J4\u0010&\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00022!\u0010'\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001f0(H\u0086\bJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u001b\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010-\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J,\u0010/\u001a\u00020\u001f2!\u00100\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001a0(H\u0086\bJ#\u00101\u001a\u00020\u001f2\u0018\u00102\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u001f0(H\u0082\bJ\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u00104\u001a\u00020\fH\u0002R<\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u00052\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u0005@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R0\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00065"}, d2={"Landroidx/compose/runtime/collection/IdentityScopeMap;", "T", "", "()V", "<set-?>", "", "Landroidx/compose/runtime/collection/IdentityArraySet;", "scopeSets", "getScopeSets", "()[Landroidx/compose/runtime/collection/IdentityArraySet;", "[Landroidx/compose/runtime/collection/IdentityArraySet;", "size", "", "getSize", "()I", "setSize", "(I)V", "", "valueOrder", "getValueOrder", "()[I", "values", "getValues", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "add", "", "value", "scope", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "clear", "", "contains", "element", "find", "findExactIndex", "midIndex", "valueHash", "forEachScopeOf", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "getOrCreateIdentitySet", "remove", "removeScope", "(Ljava/lang/Object;)V", "removeValueIf", "predicate", "removingScopes", "removalOperation", "scopeSetAt", "index", "runtime_release"})
@SourceDebugExtension(value={"SMAP\nIdentityScopeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityScopeMap.kt\nandroidx/compose/runtime/collection/IdentityScopeMap\n+ 2 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n*L\n1#1,332:1\n244#1,8:340\n252#1,17:367\n244#1,25:384\n108#2,7:333\n281#2,19:348\n*S KotlinDebug\n*F\n+ 1 IdentityScopeMap.kt\nandroidx/compose/runtime/collection/IdentityScopeMap\n*L\n228#1:340,8\n228#1:367,17\n238#1:384,25\n82#1:333,7\n229#1:348,19\n*E\n"})
public final class IdentityScopeMap<T> {
    @NotNull
    private int[] valueOrder;
    @NotNull
    private Object[] values;
    @NotNull
    private IdentityArraySet<T>[] scopeSets;
    private int size;

    public IdentityScopeMap() {
        int n = 0;
        int[] nArray = new int[50];
        IdentityScopeMap identityScopeMap = this;
        while (n < 50) {
            int n2;
            nArray[n2] = n2 = n++;
        }
        identityScopeMap.valueOrder = nArray;
        this.values = new Object[50];
        this.scopeSets = new IdentityArraySet[50];
    }

    @NotNull
    public final int[] getValueOrder() {
        return this.valueOrder;
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    @NotNull
    public final IdentityArraySet<T>[] getScopeSets() {
        return this.scopeSets;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    private final IdentityArraySet<T> scopeSetAt(int index) {
        IdentityArraySet<T> identityArraySet = this.scopeSets[this.valueOrder[index]];
        Intrinsics.checkNotNull(identityArraySet);
        return identityArraySet;
    }

    public final boolean add(@NotNull Object value, @NotNull T scope) {
        IdentityArraySet<T> valueSet = this.getOrCreateIdentitySet(value);
        return valueSet.add(scope);
    }

    public final boolean contains(@NotNull Object element) {
        return this.find(element) >= 0;
    }

    public final void forEachScopeOf(@NotNull Object value, @NotNull Function1<? super T, Unit> block) {
        boolean $i$f$forEachScopeOf = false;
        int index = this.find(value);
        if (index >= 0) {
            IdentityArraySet this_$iv = this.scopeSetAt(index);
            boolean $i$f$fastForEach = false;
            Object[] values$iv = this_$iv.getValues();
            int n = this_$iv.size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Object object = values$iv[i$iv];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                block.invoke(object);
            }
        }
    }

    private final IdentityArraySet<T> getOrCreateIdentitySet(Object value) {
        int size = this.size;
        int[] valueOrder = this.valueOrder;
        Object[] values2 = this.values;
        IdentityArraySet<T>[] scopeSets = this.scopeSets;
        int index = 0;
        if (size > 0) {
            index = this.find(value);
            if (index >= 0) {
                return this.scopeSetAt(index);
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        if (size < valueOrder.length) {
            IdentityArraySet<T> scopeSet;
            int valueIndex = valueOrder[size];
            values2[valueIndex] = value;
            IdentityArraySet<T> identityArraySet = scopeSets[valueIndex];
            if (identityArraySet == null) {
                IdentityArraySet identityArraySet2;
                IdentityArraySet it = identityArraySet2 = new IdentityArraySet();
                boolean bl = false;
                scopeSets[valueIndex] = it;
                identityArraySet = scopeSet = identityArraySet2;
            }
            if (insertIndex < size) {
                ArraysKt.copyInto((int[])valueOrder, (int[])valueOrder, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            }
            valueOrder[insertIndex] = valueIndex;
            int n = this.size;
            this.size = n + 1;
            return scopeSet;
        }
        int newSize = valueOrder.length * 2;
        int valueIndex = size;
        IdentityArraySet<T>[] identityArraySetArray = Arrays.copyOf(scopeSets, newSize);
        Intrinsics.checkNotNullExpressionValue(identityArraySetArray, (String)"copyOf(this, newSize)");
        IdentityArraySet<T>[] newScopeSets = identityArraySetArray;
        IdentityArraySet scopeSet = new IdentityArraySet();
        newScopeSets[valueIndex] = scopeSet;
        Object[] objectArray = Arrays.copyOf(values2, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newValues = objectArray;
        newValues[valueIndex] = value;
        int[] newKeyOrder = new int[newSize];
        for (int i = size + 1; i < newSize; ++i) {
            newKeyOrder[i] = i;
        }
        if (insertIndex < size) {
            ArraysKt.copyInto((int[])valueOrder, (int[])newKeyOrder, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        newKeyOrder[insertIndex] = valueIndex;
        if (insertIndex > 0) {
            ArraysKt.copyInto$default((int[])valueOrder, (int[])newKeyOrder, (int)0, (int)0, (int)insertIndex, (int)6, null);
        }
        this.scopeSets = newScopeSets;
        this.values = newValues;
        this.valueOrder = newKeyOrder;
        int n = this.size;
        this.size = n + 1;
        return scopeSet;
    }

    public final void clear() {
        IdentityArraySet<T>[] scopeSets = this.scopeSets;
        int[] valueOrder = this.valueOrder;
        Object[] values2 = this.values;
        int n = scopeSets.length;
        for (int i = 0; i < n; ++i) {
            IdentityArraySet<T> identityArraySet = scopeSets[i];
            if (identityArraySet != null) {
                identityArraySet.clear();
            }
            valueOrder[i] = i;
            values2[i] = null;
        }
        this.size = 0;
    }

    public final boolean remove(@NotNull Object value, @NotNull T scope) {
        int index = this.find(value);
        int[] valueOrder = this.valueOrder;
        IdentityArraySet<T>[] scopeSets = this.scopeSets;
        Object[] values2 = this.values;
        int size = this.size;
        if (index >= 0) {
            int valueOrderIndex = valueOrder[index];
            IdentityArraySet<T> identityArraySet = scopeSets[valueOrderIndex];
            if (identityArraySet == null) {
                return false;
            }
            IdentityArraySet<T> set = identityArraySet;
            boolean removed = set.remove(scope);
            if (set.size() == 0) {
                int startIndex = index + 1;
                int endIndex = size;
                if (startIndex < endIndex) {
                    ArraysKt.copyInto((int[])valueOrder, (int[])valueOrder, (int)index, (int)startIndex, (int)endIndex);
                }
                int newSize = size - 1;
                valueOrder[newSize] = valueOrderIndex;
                values2[valueOrderIndex] = null;
                this.size = newSize;
            }
            return removed;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super T, Boolean> predicate) {
        int i$iv;
        boolean $i$f$removeValueIf = false;
        IdentityScopeMap this_$iv = this;
        boolean $i$f$removingScopes = false;
        int[] valueOrder$iv = this_$iv.getValueOrder();
        IdentityArraySet<T>[] scopeSets$iv = this_$iv.getScopeSets();
        Object[] values$iv = this_$iv.getValues();
        int destinationIndex$iv = 0;
        int n = this_$iv.getSize();
        for (i$iv = 0; i$iv < n; ++i$iv) {
            int i$iv2;
            IdentityArraySet<T> set$iv;
            int valueIndex$iv = valueOrder$iv[i$iv];
            Intrinsics.checkNotNull(scopeSets$iv[valueIndex$iv]);
            IdentityArraySet<T> scopeSet = set$iv;
            boolean bl = false;
            IdentityArraySet<T> this_$iv2 = scopeSet;
            boolean $i$f$removeValueIf2 = false;
            Object[] values$iv2 = this_$iv2.getValues();
            int size$iv = this_$iv2.size();
            int destinationIndex$iv2 = 0;
            for (i$iv2 = 0; i$iv2 < size$iv; ++i$iv2) {
                Object item$iv;
                Intrinsics.checkNotNull((Object)values$iv2[i$iv2], (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                if (((Boolean)predicate.invoke(item$iv)).booleanValue()) continue;
                if (destinationIndex$iv2 != i$iv2) {
                    values$iv2[destinationIndex$iv2] = item$iv;
                }
                ++destinationIndex$iv2;
            }
            for (i$iv2 = destinationIndex$iv2; i$iv2 < size$iv; ++i$iv2) {
                values$iv2[i$iv2] = null;
            }
            IdentityArraySet.access$setSize$p(this_$iv2, destinationIndex$iv2);
            if (set$iv.size() <= 0) continue;
            if (destinationIndex$iv != i$iv) {
                int destinationKeyOrder$iv = valueOrder$iv[destinationIndex$iv];
                valueOrder$iv[destinationIndex$iv] = valueIndex$iv;
                valueOrder$iv[i$iv] = destinationKeyOrder$iv;
            }
            ++destinationIndex$iv;
        }
        n = this_$iv.getSize();
        for (i$iv = destinationIndex$iv; i$iv < n; ++i$iv) {
            values$iv[valueOrder$iv[i$iv]] = null;
        }
        this_$iv.setSize(destinationIndex$iv);
    }

    public final void removeScope(@NotNull T scope) {
        int i$iv;
        IdentityScopeMap this_$iv = this;
        boolean $i$f$removingScopes = false;
        int[] valueOrder$iv = this_$iv.getValueOrder();
        IdentityArraySet<T>[] scopeSets$iv = this_$iv.getScopeSets();
        Object[] values$iv = this_$iv.getValues();
        int destinationIndex$iv = 0;
        int n = this_$iv.getSize();
        for (i$iv = 0; i$iv < n; ++i$iv) {
            IdentityArraySet<T> set$iv;
            int valueIndex$iv = valueOrder$iv[i$iv];
            Intrinsics.checkNotNull(scopeSets$iv[valueIndex$iv]);
            IdentityArraySet<T> scopeSet = set$iv;
            boolean bl = false;
            scopeSet.remove(scope);
            if (set$iv.size() <= 0) continue;
            if (destinationIndex$iv != i$iv) {
                int destinationKeyOrder$iv = valueOrder$iv[destinationIndex$iv];
                valueOrder$iv[destinationIndex$iv] = valueIndex$iv;
                valueOrder$iv[i$iv] = destinationKeyOrder$iv;
            }
            ++destinationIndex$iv;
        }
        n = this_$iv.getSize();
        for (i$iv = destinationIndex$iv; i$iv < n; ++i$iv) {
            values$iv[valueOrder$iv[i$iv]] = null;
        }
        this_$iv.setSize(destinationIndex$iv);
    }

    private final void removingScopes(Function1<? super IdentityArraySet<T>, Unit> removalOperation) {
        int i;
        boolean $i$f$removingScopes = false;
        int[] valueOrder = this.getValueOrder();
        IdentityArraySet<T>[] scopeSets = this.getScopeSets();
        Object[] values2 = this.getValues();
        int destinationIndex = 0;
        int n = this.getSize();
        for (i = 0; i < n; ++i) {
            IdentityArraySet<T> set;
            int valueIndex = valueOrder[i];
            Intrinsics.checkNotNull(scopeSets[valueIndex]);
            removalOperation.invoke(set);
            if (set.size() <= 0) continue;
            if (destinationIndex != i) {
                int destinationKeyOrder = valueOrder[destinationIndex];
                valueOrder[destinationIndex] = valueIndex;
                valueOrder[i] = destinationKeyOrder;
            }
            ++destinationIndex;
        }
        n = this.getSize();
        for (i = destinationIndex; i < n; ++i) {
            values2[valueOrder[i]] = null;
        }
        this.setSize(destinationIndex);
    }

    private final int find(Object value) {
        int valueIdentity = ActualJvm_jvmKt.identityHashCode(value);
        int low = 0;
        int high = this.size - 1;
        Object[] values2 = this.values;
        int[] valueOrder = this.valueOrder;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midValue = values2[valueOrder[mid]];
            int midValHash = ActualJvm_jvmKt.identityHashCode(midValue);
            if (midValHash < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midValHash > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (value == midValue) {
                return mid;
            }
            return this.findExactIndex(mid, value, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        int i;
        Object[] values2 = this.values;
        int[] valueOrder = this.valueOrder;
        for (i = midIndex - 1; -1 < i; --i) {
            Object v = values2[valueOrder[i]];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) != valueHash) break;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v = values2[valueOrder[i]];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(this.size + 1);
    }
}

