/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\tJ#\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\bJ\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\tH\u0002J#\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\u0017H\u0086\bJ\u0011\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0001H\u0086\u0002J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0001J#\u0010!\u001a\u00020\u001d2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\bR0\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Landroidx/compose/runtime/collection/IdentityArrayIntMap;", "", "()V", "<set-?>", "", "keys", "getKeys", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "", "size", "getSize", "()I", "", "values", "getValues", "()[I", "add", "key", "value", "any", "", "predicate", "Lkotlin/Function2;", "find", "findExactIndex", "midIndex", "valueHash", "forEach", "", "block", "get", "remove", "removeValueIf", "runtime_release"})
@StabilityInferred(parameters=0)
public final class IdentityArrayIntMap {
    private int size;
    @NotNull
    private Object[] keys = new Object[4];
    @NotNull
    private int[] values = new int[4];
    public static final int $stable = 8;

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Object[] getKeys() {
        return this.keys;
    }

    @NotNull
    public final int[] getValues() {
        return this.values;
    }

    public final int get(@NotNull Object key) {
        int index = this.find(key);
        if (index < 0) {
            throw new IllegalStateException("Key not found".toString());
        }
        return this.values[index];
    }

    public final int add(@NotNull Object key, int value) {
        int[] values2 = this.values;
        int index = 0;
        if (this.size > 0) {
            index = this.find(key);
            if (index >= 0) {
                int previousValue = values2[index];
                values2[index] = value;
                return previousValue;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        int size = this.size;
        Object[] keys2 = this.keys;
        if (size == keys2.length) {
            Object[] newKeys = new Object[keys2.length * 2];
            int[] newValues = new int[keys2.length * 2];
            ArraysKt.copyInto((Object[])keys2, (Object[])newKeys, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])values2, (int[])newValues, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((Object[])keys2, (Object[])newKeys, (int)0, (int)0, (int)insertIndex, (int)6, null);
            ArraysKt.copyInto$default((int[])values2, (int[])newValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.keys = newKeys;
            this.values = newValues;
        } else {
            ArraysKt.copyInto((Object[])keys2, (Object[])keys2, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])values2, (int[])values2, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        this.keys[insertIndex] = key;
        this.values[insertIndex] = value;
        int n = this.size;
        this.size = n + 1;
        return -1;
    }

    public final boolean remove(@NotNull Object key) {
        int index = this.find(key);
        Object[] keys2 = this.keys;
        int[] values2 = this.values;
        int size = this.size;
        if (index >= 0) {
            if (index < size - 1) {
                ArraysKt.copyInto((Object[])keys2, (Object[])keys2, (int)index, (int)(index + 1), (int)size);
                ArraysKt.copyInto((int[])values2, (int[])values2, (int)index, (int)(index + 1), (int)size);
            }
            int newSize = size - 1;
            keys2[newSize] = null;
            this.size = newSize;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function2<Object, ? super Integer, Boolean> predicate) {
        int i;
        boolean $i$f$removeValueIf = false;
        Object[] keys2 = this.getKeys();
        int[] values2 = this.getValues();
        int size = this.getSize();
        int destinationIndex = 0;
        for (i = 0; i < size; ++i) {
            Object key;
            Intrinsics.checkNotNull((Object)keys2[i], (String)"null cannot be cast to non-null type kotlin.Any");
            int value = values2[i];
            if (((Boolean)predicate.invoke(key, (Object)value)).booleanValue()) continue;
            if (destinationIndex != i) {
                keys2[destinationIndex] = key;
                values2[destinationIndex] = value;
            }
            ++destinationIndex;
        }
        for (i = destinationIndex; i < size; ++i) {
            keys2[i] = null;
        }
        this.size = destinationIndex;
    }

    public final boolean any(@NotNull Function2<Object, ? super Integer, Boolean> predicate) {
        boolean $i$f$any = false;
        Object[] keys2 = this.getKeys();
        int[] values2 = this.getValues();
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            Object object = keys2[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            if (!((Boolean)predicate.invoke(object, (Object)values2[i])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final void forEach(@NotNull Function2<Object, ? super Integer, Unit> block) {
        boolean $i$f$forEach = false;
        Object[] keys2 = this.getKeys();
        int[] values2 = this.getValues();
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            Object object = keys2[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            block.invoke(object, (Object)values2[i]);
        }
    }

    private final int find(Object key) {
        int low = 0;
        int high = this.size - 1;
        int valueIdentity = ActualJvm_jvmKt.identityHashCode(key);
        Object[] keys2 = this.keys;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = keys2[mid];
            int midIdentity = ActualJvm_jvmKt.identityHashCode(midVal);
            if (midIdentity < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midIdentity > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (midVal == key) {
                return mid;
            }
            return this.findExactIndex(mid, key, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        Object v;
        int i;
        Object[] keys2 = this.keys;
        int size = this.size;
        for (i = midIndex - 1; -1 < i; --i) {
            v = keys2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) != valueHash) break;
        }
        for (i = midIndex + 1; i < size; ++i) {
            v = keys2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(size + 1);
    }
}

