/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.saveable;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.SaveableStateRegistry;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00020\u00042\u00020\u0005BE\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001f\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000e\u00a2\u0006\u0002\u0010\u0017J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0002JK\u0010\u001e\u001a\u00020\u001a2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000e\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001f"}, d2={"Landroidx/compose/runtime/saveable/SaveableHolder;", "T", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/saveable/SaverScope;", "Landroidx/compose/runtime/RememberObserver;", "saver", "Landroidx/compose/runtime/saveable/Saver;", "registry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry;", "key", "", "value", "inputs", "", "(Landroidx/compose/runtime/saveable/Saver;Landroidx/compose/runtime/saveable/SaveableStateRegistry;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V", "entry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry$Entry;", "[Ljava/lang/Object;", "Ljava/lang/Object;", "canBeSaved", "", "getValueIfInputsDidntChange", "([Ljava/lang/Object;)Ljava/lang/Object;", "invoke", "onAbandoned", "", "onForgotten", "onRemembered", "register", "update", "runtime-saveable_release"})
@SourceDebugExtension(value={"SMAP\nRememberSaveable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberSaveable.kt\nandroidx/compose/runtime/saveable/SaveableHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
final class SaveableHolder<T>
implements Function0<Object>,
SaverScope,
RememberObserver {
    @NotNull
    private Saver<T, Object> saver;
    @Nullable
    private SaveableStateRegistry registry;
    @NotNull
    private String key;
    private T value;
    @NotNull
    private Object[] inputs;
    @Nullable
    private SaveableStateRegistry.Entry entry;

    public SaveableHolder(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry2, @NotNull String key, T value, @NotNull Object[] inputs) {
        this.saver = saver;
        this.registry = registry2;
        this.key = key;
        this.value = value;
        this.inputs = inputs;
    }

    public final void update(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry2, @NotNull String key, T value, @NotNull Object[] inputs) {
        boolean entryIsOutdated = false;
        if (this.registry != registry2) {
            this.registry = registry2;
            entryIsOutdated = true;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)key)) {
            this.key = key;
            entryIsOutdated = true;
        }
        this.saver = saver;
        this.value = value;
        this.inputs = inputs;
        if (this.entry != null && entryIsOutdated) {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry != null) {
                entry.unregister();
            }
            this.entry = null;
            this.register();
        }
    }

    private final void register() {
        SaveableStateRegistry registry2 = this.registry;
        if (!(this.entry == null)) {
            boolean bl = false;
            String string = "entry(" + this.entry + ") is not null";
            throw new IllegalArgumentException(string.toString());
        }
        if (registry2 != null) {
            RememberSaveableKt.access$requireCanBeSaved(registry2, this.invoke());
            this.entry = registry2.registerProvider(this.key, (Function0<? extends Object>)((Function0)this));
        }
    }

    @Nullable
    public Object invoke() {
        Saver<T, Object> $this$invoke_u24lambda_u242 = this.saver;
        boolean bl = false;
        Saver<T, Object> saver = $this$invoke_u24lambda_u242;
        SaverScope saverScope = this;
        T t = this.value;
        if (t == null) {
            SaverScope saverScope2 = saverScope;
            Saver<T, Object> saver2 = saver;
            boolean bl2 = false;
            String string = "Value should be initialized";
            Saver<T, Object> saver3 = saver2;
            SaverScope saverScope3 = saverScope2;
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        return saver.save(saverScope, t);
    }

    @Override
    public boolean canBeSaved(@NotNull Object value) {
        SaveableStateRegistry registry2 = this.registry;
        return registry2 == null || registry2.canBeSaved(value);
    }

    public void onRemembered() {
        this.register();
    }

    public void onForgotten() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    public void onAbandoned() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    @Nullable
    public final T getValueIfInputsDidntChange(@NotNull Object[] inputs) {
        return Arrays.equals(inputs, this.inputs) ? (T)this.value : null;
    }
}

