/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.accessibility;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.platform.accessibility.CollectionInfoKt;
import androidx.compose.ui.semantics.CollectionInfo;
import androidx.compose.ui.semantics.CollectionItemInfo;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\u0014\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010*\u00020\u0002H\u0002\u001a\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00130\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0016"}, d2={"isLazyCollection", "", "Landroidx/compose/ui/semantics/CollectionInfo;", "(Landroidx/compose/ui/semantics/CollectionInfo;)Z", "calculateIfHorizontallyStacked", "items", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "setCollectionInfo", "", "node", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "setCollectionItemInfo", "hasCollectionInfo", "toAccessibilityCollectionInfo", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat$CollectionInfoCompat;", "kotlin.jvm.PlatformType", "toAccessibilityCollectionItemInfo", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat$CollectionItemInfoCompat;", "Landroidx/compose/ui/semantics/CollectionItemInfo;", "itemNode", "ui_release"})
@SourceDebugExtension(value={"SMAP\nCollectionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionInfo.kt\nandroidx/compose/ui/platform/accessibility/CollectionInfoKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 TempListUtils.kt\nandroidx/compose/ui/TempListUtilsKt\n*L\n1#1,153:1\n33#2,6:154\n33#2,6:160\n38#3,11:166\n68#3,7:177\n*S KotlinDebug\n*F\n+ 1 CollectionInfo.kt\nandroidx/compose/ui/platform/accessibility/CollectionInfoKt\n*L\n43#1:154,6\n87#1:160,6\n122#1:166,11\n130#1:177,7\n*E\n"})
public final class CollectionInfoKt {
    public static final void setCollectionInfo(@NotNull SemanticsNode node, @NotNull AccessibilityNodeInfoCompat info) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        CollectionInfo collectionInfo = SemanticsConfigurationKt.getOrNull(node.getConfig(), SemanticsProperties.INSTANCE.getCollectionInfo());
        if (collectionInfo != null) {
            info.setCollectionInfo((Object)CollectionInfoKt.toAccessibilityCollectionInfo(collectionInfo));
            return;
        }
        List groupedChildren = new ArrayList();
        if (SemanticsConfigurationKt.getOrNull(node.getConfig(), SemanticsProperties.INSTANCE.getSelectableGroup()) != null) {
            List<SemanticsNode> $this$fastForEach$iv = node.getReplacedChildren$ui_release();
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                SemanticsNode item$iv;
                SemanticsNode childNode = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                if (!childNode.getConfig().contains(SemanticsProperties.INSTANCE.getSelected())) continue;
                groupedChildren.add(childNode);
            }
        }
        if (!((Collection)groupedChildren).isEmpty()) {
            boolean isHorizontal = CollectionInfoKt.calculateIfHorizontallyStacked(groupedChildren);
            info.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)(isHorizontal ? 1 : ((Collection)groupedChildren).size()), (int)(isHorizontal ? ((Collection)groupedChildren).size() : 1), (boolean)false, (int)0));
        }
    }

    public static final void setCollectionItemInfo(@NotNull SemanticsNode node, @NotNull AccessibilityNodeInfoCompat info) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        CollectionItemInfo collectionItemInfo = SemanticsConfigurationKt.getOrNull(node.getConfig(), SemanticsProperties.INSTANCE.getCollectionItemInfo());
        if (collectionItemInfo != null) {
            info.setCollectionItemInfo((Object)CollectionInfoKt.toAccessibilityCollectionItemInfo(collectionItemInfo, node));
        }
        SemanticsNode semanticsNode2 = node.getParent();
        if (semanticsNode2 == null) {
            return;
        }
        SemanticsNode parentNode = semanticsNode2;
        if (SemanticsConfigurationKt.getOrNull(parentNode.getConfig(), SemanticsProperties.INSTANCE.getSelectableGroup()) != null) {
            boolean isHorizontal;
            AccessibilityNodeInfoCompat.CollectionItemInfoCompat itemInfo2;
            CollectionInfo collectionInfo = SemanticsConfigurationKt.getOrNull(parentNode.getConfig(), SemanticsProperties.INSTANCE.getCollectionInfo());
            if (collectionInfo != null && CollectionInfoKt.isLazyCollection(collectionInfo)) {
                return;
            }
            if (!node.getConfig().contains(SemanticsProperties.INSTANCE.getSelected())) {
                return;
            }
            List groupedChildren = new ArrayList();
            int index = 0;
            List<SemanticsNode> $this$fastForEach$iv = parentNode.getReplacedChildren$ui_release();
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                SemanticsNode item$iv;
                SemanticsNode childNode = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                if (!childNode.getConfig().contains(SemanticsProperties.INSTANCE.getSelected())) continue;
                groupedChildren.add(childNode);
                if (childNode.getLayoutNode$ui_release().getPlaceOrder$ui_release() >= node.getLayoutNode$ui_release().getPlaceOrder$ui_release()) continue;
                ++index;
            }
            if (!((Collection)groupedChildren).isEmpty() && (itemInfo2 = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)((isHorizontal = CollectionInfoKt.calculateIfHorizontallyStacked(groupedChildren)) ? 0 : index), (int)1, (int)(isHorizontal ? index : 0), (int)1, (boolean)false, (boolean)node.getConfig().getOrElse(SemanticsProperties.INSTANCE.getSelected(), setCollectionItemInfo.itemInfo.1.INSTANCE))) != null) {
                info.setCollectionItemInfo((Object)itemInfo2);
            }
        }
    }

    public static final boolean hasCollectionInfo(@NotNull SemanticsNode $this$hasCollectionInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCollectionInfo, (String)"<this>");
        return SemanticsConfigurationKt.getOrNull($this$hasCollectionInfo.getConfig(), SemanticsProperties.INSTANCE.getCollectionInfo()) != null || SemanticsConfigurationKt.getOrNull($this$hasCollectionInfo.getConfig(), SemanticsProperties.INSTANCE.getSelectableGroup()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean calculateIfHorizontallyStacked(List<SemanticsNode> items) {
        long l;
        List list;
        if (((Collection)items).size() < 2) {
            return true;
        }
        List<SemanticsNode> $this$fastZipWithNext$iv = items;
        boolean $i$f$fastZipWithNext = false;
        if ($this$fastZipWithNext$iv.size() == 0 || $this$fastZipWithNext$iv.size() == 1) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            SemanticsNode current$iv = $this$fastZipWithNext$iv.get(0);
            int n = CollectionsKt.getLastIndex($this$fastZipWithNext$iv);
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void el2;
                void el1;
                SemanticsNode next$iv;
                SemanticsNode semanticsNode2 = next$iv = $this$fastZipWithNext$iv.get(i$iv + 1);
                SemanticsNode semanticsNode3 = current$iv;
                List list2 = result$iv;
                boolean bl = false;
                list2.add(Offset.box-impl((long)OffsetKt.Offset((float)Math.abs(Offset.getX-impl((long)el1.getBoundsInRoot().getCenter-F1C5BW0()) - Offset.getX-impl((long)el2.getBoundsInRoot().getCenter-F1C5BW0())), (float)Math.abs(Offset.getY-impl((long)el1.getBoundsInRoot().getCenter-F1C5BW0()) - Offset.getY-impl((long)el2.getBoundsInRoot().getCenter-F1C5BW0())))));
                current$iv = next$iv;
            }
            list = result$iv;
        }
        List deltas = list;
        if (((Collection)deltas).size() == 1) {
            l = ((Offset)CollectionsKt.first((List)deltas)).unbox-impl();
        } else {
            List $this$fastReduce$iv = deltas;
            boolean $i$f$fastReduce = false;
            if ($this$fastReduce$iv.isEmpty()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = CollectionsKt.first((List)$this$fastReduce$iv);
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex((List)$this$fastReduce$iv);
            if (i$iv <= n) {
                while (true) {
                    void element;
                    long el1 = ((Offset)$this$fastReduce$iv.get(i$iv)).unbox-impl();
                    long result2 = ((Offset)accumulator$iv).unbox-impl();
                    boolean bl = false;
                    accumulator$iv = Offset.box-impl((long)Offset.plus-MK-Hz9U((long)result2, (long)element));
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            l = ((Offset)accumulator$iv).unbox-impl();
        }
        long l2 = l;
        float deltaX = Offset.component1-impl((long)l2);
        float deltaY = Offset.component2-impl((long)l2);
        return deltaY < deltaX;
    }

    private static final boolean isLazyCollection(CollectionInfo $this$isLazyCollection) {
        return $this$isLazyCollection.getRowCount() < 0 || $this$isLazyCollection.getColumnCount() < 0;
    }

    private static final AccessibilityNodeInfoCompat.CollectionInfoCompat toAccessibilityCollectionInfo(CollectionInfo $this$toAccessibilityCollectionInfo) {
        return AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)$this$toAccessibilityCollectionInfo.getRowCount(), (int)$this$toAccessibilityCollectionInfo.getColumnCount(), (boolean)false, (int)0);
    }

    private static final AccessibilityNodeInfoCompat.CollectionItemInfoCompat toAccessibilityCollectionItemInfo(CollectionItemInfo $this$toAccessibilityCollectionItemInfo, SemanticsNode itemNode) {
        return AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)$this$toAccessibilityCollectionItemInfo.getRowIndex(), (int)$this$toAccessibilityCollectionItemInfo.getRowSpan(), (int)$this$toAccessibilityCollectionItemInfo.getColumnIndex(), (int)$this$toAccessibilityCollectionItemInfo.getColumnSpan(), (boolean)false, (boolean)itemNode.getConfig().getOrElse(SemanticsProperties.INSTANCE.getSelected(), toAccessibilityCollectionItemInfo.1.INSTANCE));
    }
}

