/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/lint/MultipleAwaitPointerEventScopesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "reportedNodes", "", "Lorg/jetbrains/uast/UElement;", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "", "", "searchAwaitPointerScopeCalls", "", "parent", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nMultipleAwaitPointerEventScopesDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleAwaitPointerEventScopesDetector.kt\nandroidx/compose/ui/lint/MultipleAwaitPointerEventScopesDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,126:1\n123#2,2:127\n*S KotlinDebug\n*F\n+ 1 MultipleAwaitPointerEventScopesDetector.kt\nandroidx/compose/ui/lint/MultipleAwaitPointerEventScopesDetector\n*L\n63#1:127,2\n*E\n"})
public final class MultipleAwaitPointerEventScopesDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<UElement> reportedNodes = new LinkedHashSet();
    @NotNull
    public static final String IssueId = "MultipleAwaitPointerEventScopes";
    @NotNull
    public static final String ErrorMessage = "Suspicious use of multiple awaitPointerEventScope blocks. Using multiple awaitPointerEventScope blocks may cause some input events to be dropped.";
    @NotNull
    private static final Issue MultipleAwaitPointerEventScopes = Issue.Companion.create("MultipleAwaitPointerEventScopes", "Suspicious use of multiple awaitPointerEventScope blocks. Using multiple awaitPointerEventScope blocks may cause some input events to be dropped.", "Pointer Input events are queued inside awaitPointerEventScope. Multiple calls to awaitPointerEventScope may exit the scope. During this time there is no guarantee that the events will be queued and some events may be dropped. It is recommended to use a single top-level block and perform the pointer events processing within such block.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(MultipleAwaitPointerEventScopesDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Ui.Pointer.INSTANCE.getAwaitPointerEventScope().getShortName());
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.reportedNodes.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, Names.Ui.Pointer.INSTANCE.getPackageName())) {
            return;
        }
        UDeclaration containingDeclaration = UDeclarationKt.getContainingDeclaration((UElement)((UElement)node));
        Sequence $this$first$iv = UElementKt.getWithContainingElements((UElement)((UElement)node));
        boolean $i$f$first = false;
        Iterator iterator = $this$first$iv.iterator();
        do {
            block9: {
                block8: {
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    element$iv = iterator.next();
                    UElement it = (UElement)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)containingDeclaration)) break block8;
                    if (!(it instanceof UExpression)) break block9;
                    PsiType psiType = ((UExpression)it).getExpressionType();
                    boolean bl3 = psiType != null ? PsiUtilsKt.inheritsFrom(psiType, Names.Ui.INSTANCE.getModifier()) : false;
                    if (!bl3) break block9;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        UElement boundaryElement = (UElement)element$iv;
        int awaitPointerEventCalls = this.searchAwaitPointerScopeCalls(boundaryElement);
        if (awaitPointerEventCalls <= 1) {
            return;
        }
        if (!this.reportedNodes.contains(node)) {
            JavaContext.report$default((JavaContext)context, (Issue)MultipleAwaitPointerEventScopes, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)ErrorMessage, null, (int)16, null);
            this.reportedNodes.add((UElement)node);
        }
    }

    private final int searchAwaitPointerScopeCalls(UElement parent) {
        Ref.IntRef awaitPointerEventCallsCount = new Ref.IntRef();
        parent.accept((UastVisitor)new AbstractUastVisitor(awaitPointerEventCallsCount){
            final /* synthetic */ Ref.IntRef $awaitPointerEventCallsCount;
            {
                this.$awaitPointerEventCallsCount = $awaitPointerEventCallsCount;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node));
                PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod method = psiMethod;
                if (!PsiUtilsKt.isInPackageName(method, Names.Ui.Pointer.INSTANCE.getPackageName())) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)method.getName(), (Object)Names.Ui.Pointer.INSTANCE.getAwaitPointerEventScope().getShortName())) {
                    int n = this.$awaitPointerEventCallsCount.element;
                    this.$awaitPointerEventCallsCount.element = n + 1;
                }
                return false;
            }
        });
        return awaitPointerEventCallsCount.element;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/lint/MultipleAwaitPointerEventScopesDetector$Companion;", "", "()V", "ErrorMessage", "", "IssueId", "MultipleAwaitPointerEventScopes", "Lcom/android/tools/lint/detector/api/Issue;", "getMultipleAwaitPointerEventScopes", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getMultipleAwaitPointerEventScopes() {
            return MultipleAwaitPointerEventScopes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

