/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.graphics.Region;
import android.view.View;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat_androidKt;
import androidx.compose.ui.platform.AndroidViewsHandler;
import androidx.compose.ui.platform.OpenEndFloatRange;
import androidx.compose.ui.platform.OpenEndRange;
import androidx.compose.ui.platform.ScrollObservationScope;
import androidx.compose.ui.platform.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.viewinterop.AndroidViewHolder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0013\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\f\u0010\u0017\u001a\u00020\n*\u00020\u0002H\u0002\u001a\f\u0010\u0018\u001a\u00020\n*\u00020\u0002H\u0002\u001a\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\b\u0012\u0004\u0012\u00020\u001a0\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\n0!H\u0002\u001a\u0018\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020$0#*\u00020%H\u0000\u001a\f\u0010&\u001a\u00020\n*\u00020\u0002H\u0002\u001a \u0010'\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0002\u001a\u0014\u0010*\u001a\u00020\n*\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0002\u001a\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010(*\u00020\u00012\u0006\u0010.\u001a\u00020\u0001H\u0080\u0002\u001a\u0016\u0010/\u001a\u0004\u0018\u000100*\u0002012\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u001b\u00102\u001a\u0004\u0018\u00010\u0006*\u000203H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u00105\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\f\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\"\u0018\u0010\r\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001e\u0010\u0010\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00066"}, d2={"getTraversalIndex", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "getGetTraversalIndex", "(Landroidx/compose/ui/semantics/SemanticsNode;)F", "infoContentDescriptionOrNull", "", "getInfoContentDescriptionOrNull", "(Landroidx/compose/ui/semantics/SemanticsNode;)Ljava/lang/String;", "isPassword", "", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isRtl", "isTextField", "isTraversalGroup", "(Landroidx/compose/ui/semantics/SemanticsNode;)Ljava/lang/Boolean;", "isVisible", "isVisible$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "accessibilityEquals", "Landroidx/compose/ui/semantics/AccessibilityAction;", "other", "", "enabled", "excludeLineAndPageGranularities", "findById", "Landroidx/compose/ui/platform/ScrollObservationScope;", "", "id", "", "findClosestParentNode", "Landroidx/compose/ui/node/LayoutNode;", "selector", "Lkotlin/Function1;", "getAllUncoveredSemanticsNodesToMap", "", "Landroidx/compose/ui/platform/SemanticsNodeWithAdjustedBounds;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "hasPaneTitle", "overlaps", "Landroidx/compose/ui/platform/OpenEndRange;", "it", "propertiesDeleted", "oldNode", "Landroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat$SemanticsNodeCopy;", "rangeUntil", "that", "semanticsIdToView", "Landroid/view/View;", "Landroidx/compose/ui/platform/AndroidViewsHandler;", "toLegacyClassName", "Landroidx/compose/ui/semantics/Role;", "toLegacyClassName-V4PA4sw", "(I)Ljava/lang/String;", "ui_release"})
@SourceDebugExtension(value={"SMAP\nAndroidComposeViewAccessibilityDelegateCompat.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3501:1\n288#2,2:3502\n1#3:3504\n*S KotlinDebug\n*F\n+ 1 AndroidComposeViewAccessibilityDelegateCompat.android.kt\nandroidx/compose/ui/platform/AndroidComposeViewAccessibilityDelegateCompat_androidKt\n*L\n3500#1:3502,2\n*E\n"})
public final class AndroidComposeViewAccessibilityDelegateCompat_androidKt {
    @NotNull
    public static final OpenEndRange<Float> rangeUntil(float $this$rangeUntil, float that) {
        return new OpenEndFloatRange($this$rangeUntil, that);
    }

    private static final boolean overlaps(OpenEndRange<Float> $this$overlaps, OpenEndRange<Float> it) {
        return !$this$overlaps.isEmpty() && !it.isEmpty() && Math.max(((Number)$this$overlaps.getStart()).floatValue(), ((Number)it.getStart()).floatValue()) < Math.min(((Number)$this$overlaps.getEndExclusive()).floatValue(), ((Number)it.getEndExclusive()).floatValue());
    }

    private static final LayoutNode findClosestParentNode(LayoutNode $this$findClosestParentNode, Function1<? super LayoutNode, Boolean> selector) {
        for (LayoutNode currentParent = $this$findClosestParentNode.getParent$ui_release(); currentParent != null; currentParent = currentParent.getParent$ui_release()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean enabled(SemanticsNode $this$enabled) {
        return SemanticsConfigurationKt.getOrNull($this$enabled.getConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
    }

    private static final boolean isVisible(SemanticsNode $this$isVisible) {
        return !$this$isVisible.isTransparent$ui_release() && !$this$isVisible.getUnmergedConfig$ui_release().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    private static /* synthetic */ void isVisible$annotations(SemanticsNode semanticsNode2) {
    }

    private static final boolean propertiesDeleted(SemanticsNode $this$propertiesDeleted, AndroidComposeViewAccessibilityDelegateCompat.SemanticsNodeCopy oldNode) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : oldNode.getUnmergedConfig()) {
            if ($this$propertiesDeleted.getConfig().contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static final boolean hasPaneTitle(SemanticsNode $this$hasPaneTitle) {
        return $this$hasPaneTitle.getConfig().contains(SemanticsProperties.INSTANCE.getPaneTitle());
    }

    private static final boolean isPassword(SemanticsNode $this$isPassword) {
        return $this$isPassword.getConfig().contains(SemanticsProperties.INSTANCE.getPassword());
    }

    private static final boolean isTextField(SemanticsNode $this$isTextField) {
        return $this$isTextField.getUnmergedConfig$ui_release().contains(SemanticsActions.INSTANCE.getSetText());
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    private static final Boolean isTraversalGroup(SemanticsNode $this$isTraversalGroup) {
        return SemanticsConfigurationKt.getOrNull($this$isTraversalGroup.getConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
    }

    private static final float getGetTraversalIndex(SemanticsNode $this$getTraversalIndex) {
        if ($this$getTraversalIndex.getConfig().contains(SemanticsProperties.INSTANCE.getTraversalIndex())) {
            return ((Number)$this$getTraversalIndex.getConfig().get(SemanticsProperties.INSTANCE.getTraversalIndex())).floatValue();
        }
        return 0.0f;
    }

    private static final String getInfoContentDescriptionOrNull(SemanticsNode $this$infoContentDescriptionOrNull) {
        List<String> list = SemanticsConfigurationKt.getOrNull($this$infoContentDescriptionOrNull.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getContentDescription());
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean excludeLineAndPageGranularities(SemanticsNode $this$excludeLineAndPageGranularities) {
        if (AndroidComposeViewAccessibilityDelegateCompat_androidKt.isTextField($this$excludeLineAndPageGranularities) && !Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getFocused()), (Object)true)) {
            return true;
        }
        LayoutNode ancestor2 = AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($this$excludeLineAndPageGranularities.getLayoutNode$ui_release(), (Function1<? super LayoutNode, Boolean>)((Function1)excludeLineAndPageGranularities.ancestor.1.INSTANCE));
        if (ancestor2 == null) return false;
        SemanticsConfiguration semanticsConfiguration = ancestor2.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration == null) return true;
        boolean bl = Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(semanticsConfiguration, SemanticsProperties.INSTANCE.getFocused()), (Object)true);
        if (bl) return false;
        return true;
    }

    private static final boolean accessibilityEquals(AccessibilityAction<?> $this$accessibilityEquals, Object other) {
        if ($this$accessibilityEquals == other) {
            return true;
        }
        if (!(other instanceof AccessibilityAction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$accessibilityEquals.getLabel(), (Object)((AccessibilityAction)other).getLabel())) {
            return false;
        }
        if ($this$accessibilityEquals.getAction() == null && ((AccessibilityAction)other).getAction() != null) {
            return false;
        }
        return $this$accessibilityEquals.getAction() == null || ((AccessibilityAction)other).getAction() != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Integer, SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToMap(@NotNull SemanticsOwner $this$getAllUncoveredSemanticsNodesToMap) {
        void $this$getAllUncoveredSemanticsNodesToMap_u24lambda_u241_u24lambda_u240;
        Region region;
        Intrinsics.checkNotNullParameter((Object)$this$getAllUncoveredSemanticsNodesToMap, (String)"<this>");
        SemanticsNode root2 = $this$getAllUncoveredSemanticsNodesToMap.getUnmergedRootSemanticsNode();
        Map nodes = new LinkedHashMap();
        if (!root2.getLayoutNode$ui_release().isPlaced() || !root2.getLayoutNode$ui_release().isAttached()) {
            return nodes;
        }
        Region it = region = new Region();
        boolean bl = false;
        Rect rect = root2.getBoundsInRoot();
        Region region2 = it;
        boolean bl2 = false;
        region2.set(new android.graphics.Rect(MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u241_u24lambda_u240.getLeft()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u241_u24lambda_u240.getTop()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u241_u24lambda_u240.getRight()), MathKt.roundToInt((float)$this$getAllUncoveredSemanticsNodesToMap_u24lambda_u241_u24lambda_u240.getBottom())));
        Region unaccountedSpace = region;
        AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root2, nodes, root2);
        return nodes;
    }

    @Nullable
    public static final ScrollObservationScope findById(@NotNull List<ScrollObservationScope> $this$findById, int id2) {
        Intrinsics.checkNotNullParameter($this$findById, (String)"<this>");
        int n = $this$findById.size();
        for (int index = 0; index < n; ++index) {
            if ($this$findById.get(index).getSemanticsNodeId() != id2) continue;
            return $this$findById.get(index);
        }
        return null;
    }

    private static final String toLegacyClassName-V4PA4sw(int $this$toLegacyClassName_u2dV4PA4sw) {
        int n = $this$toLegacyClassName_u2dV4PA4sw;
        return Role.equals-impl0(n, Role.Companion.getButton-o7Vup1c()) ? "android.widget.Button" : (Role.equals-impl0(n, Role.Companion.getCheckbox-o7Vup1c()) ? "android.widget.CheckBox" : (Role.equals-impl0(n, Role.Companion.getRadioButton-o7Vup1c()) ? "android.widget.RadioButton" : (Role.equals-impl0(n, Role.Companion.getImage-o7Vup1c()) ? "android.widget.ImageView" : (Role.equals-impl0(n, Role.Companion.getDropdownList-o7Vup1c()) ? "android.widget.Spinner" : null))));
    }

    @Nullable
    public static final View semanticsIdToView(@NotNull AndroidViewsHandler $this$semanticsIdToView, int id2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$semanticsIdToView), (String)"<this>");
            Set<Map.Entry<LayoutNode, AndroidViewHolder>> set = $this$semanticsIdToView.getLayoutNodeToHolder().entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"layoutNodeToHolder.entries");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!(((LayoutNode)it.getKey()).getSemanticsId() == id2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        Map.Entry entry = v1;
        return (View)(entry != null ? (AndroidViewHolder)((Object)entry.getValue()) : null);
    }

    private static final void getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(Region unaccountedSpace, SemanticsNode root2, Map<Integer, SemanticsNodeWithAdjustedBounds> nodes, SemanticsNode currentNode) {
        int virtualViewId;
        boolean notAttachedOrPlaced;
        boolean bl = notAttachedOrPlaced = !currentNode.getLayoutNode$ui_release().isPlaced() || !currentNode.getLayoutNode$ui_release().isAttached();
        if (unaccountedSpace.isEmpty() && currentNode.getId() != root2.getId() || notAttachedOrPlaced && !currentNode.isFake$ui_release()) {
            return;
        }
        Rect touchBoundsInRoot = currentNode.getTouchBoundsInRoot();
        android.graphics.Rect boundsInRoot = new android.graphics.Rect(MathKt.roundToInt((float)touchBoundsInRoot.getLeft()), MathKt.roundToInt((float)touchBoundsInRoot.getTop()), MathKt.roundToInt((float)touchBoundsInRoot.getRight()), MathKt.roundToInt((float)touchBoundsInRoot.getBottom()));
        Region region = new Region();
        Object it = region;
        boolean bl22 = false;
        it.set(boundsInRoot);
        Region region2 = region;
        int n = virtualViewId = currentNode.getId() == root2.getId() ? -1 : currentNode.getId();
        if (region2.op(unaccountedSpace, region2, Region.Op.INTERSECT)) {
            it = nodes;
            Integer bl22 = virtualViewId;
            android.graphics.Rect rect = region2.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"region.bounds");
            SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = new SemanticsNodeWithAdjustedBounds(currentNode, rect);
            it.put(bl22, semanticsNodeWithAdjustedBounds);
            List<SemanticsNode> children = currentNode.getReplacedChildren$ui_release();
            for (int i = children.size() - 1; -1 < i; --i) {
                AndroidComposeViewAccessibilityDelegateCompat_androidKt.getAllUncoveredSemanticsNodesToMap$findAllSemanticNodesRecursive(unaccountedSpace, root2, nodes, children.get(i));
            }
            unaccountedSpace.op(boundsInRoot, unaccountedSpace, Region.Op.REVERSE_DIFFERENCE);
        } else if (currentNode.isFake$ui_release()) {
            SemanticsNode parentNode = currentNode.getParent();
            Object object = parentNode;
            Rect boundsForFakeNode = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? parentNode.getBoundsInRoot() : new Rect(0.0f, 0.0f, 10.0f, 10.0f);
            Integer n2 = virtualViewId;
            nodes.put(n2, new SemanticsNodeWithAdjustedBounds(currentNode, new android.graphics.Rect(MathKt.roundToInt((float)boundsForFakeNode.getLeft()), MathKt.roundToInt((float)boundsForFakeNode.getTop()), MathKt.roundToInt((float)boundsForFakeNode.getRight()), MathKt.roundToInt((float)boundsForFakeNode.getBottom()))));
        } else if (virtualViewId == -1) {
            Map<Integer, SemanticsNodeWithAdjustedBounds> map = nodes;
            Integer n3 = virtualViewId;
            android.graphics.Rect rect = region2.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"region.bounds");
            SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = new SemanticsNodeWithAdjustedBounds(currentNode, rect);
            map.put(n3, semanticsNodeWithAdjustedBounds);
        }
    }

    public static final /* synthetic */ boolean access$isRtl(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isRtl($receiver);
    }

    public static final /* synthetic */ String access$getInfoContentDescriptionOrNull(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.getInfoContentDescriptionOrNull($receiver);
    }

    public static final /* synthetic */ boolean access$isTextField(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isTextField($receiver);
    }

    public static final /* synthetic */ boolean access$isPassword(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isPassword($receiver);
    }

    public static final /* synthetic */ boolean access$enabled(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.enabled($receiver);
    }

    public static final /* synthetic */ boolean access$isVisible(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isVisible($receiver);
    }

    public static final /* synthetic */ boolean access$excludeLineAndPageGranularities(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.excludeLineAndPageGranularities($receiver);
    }

    public static final /* synthetic */ LayoutNode access$findClosestParentNode(LayoutNode $receiver, Function1 selector) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($receiver, (Function1<? super LayoutNode, Boolean>)selector);
    }

    public static final /* synthetic */ boolean access$hasPaneTitle(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.hasPaneTitle($receiver);
    }

    public static final /* synthetic */ boolean access$accessibilityEquals(AccessibilityAction $receiver, Object other) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.accessibilityEquals($receiver, other);
    }

    public static final /* synthetic */ boolean access$propertiesDeleted(SemanticsNode $receiver, AndroidComposeViewAccessibilityDelegateCompat.SemanticsNodeCopy oldNode) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.propertiesDeleted($receiver, oldNode);
    }

    public static final /* synthetic */ String access$toLegacyClassName-V4PA4sw(int $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.toLegacyClassName-V4PA4sw($receiver);
    }

    public static final /* synthetic */ boolean access$overlaps(OpenEndRange $receiver, OpenEndRange it) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.overlaps($receiver, it);
    }

    public static final /* synthetic */ float access$getGetTraversalIndex(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.getGetTraversalIndex($receiver);
    }

    public static final /* synthetic */ Boolean access$isTraversalGroup(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isTraversalGroup($receiver);
    }
}

